/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.OrderDetails;

@Schema(description="Represents an order placed by Amazon, including the purchase order number, current state, and order details.")
public class Order {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="purchaseOrderState")
    private PurchaseOrderStateEnum purchaseOrderState = null;
    @SerializedName(value="orderDetails")
    private OrderDetails orderDetails = null;

    public Order purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number for this order. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public Order purchaseOrderState(PurchaseOrderStateEnum purchaseOrderState) {
        this.purchaseOrderState = purchaseOrderState;
        return this;
    }

    @Schema(required=true, description="This field will contain the current state of the purchase order.")
    public PurchaseOrderStateEnum getPurchaseOrderState() {
        return this.purchaseOrderState;
    }

    public void setPurchaseOrderState(PurchaseOrderStateEnum purchaseOrderState) {
        this.purchaseOrderState = purchaseOrderState;
    }

    public Order orderDetails(OrderDetails orderDetails) {
        this.orderDetails = orderDetails;
        return this;
    }

    @Schema(description="")
    public OrderDetails getOrderDetails() {
        return this.orderDetails;
    }

    public void setOrderDetails(OrderDetails orderDetails) {
        this.orderDetails = orderDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.purchaseOrderNumber, order.purchaseOrderNumber) && Objects.equals((Object)this.purchaseOrderState, (Object)order.purchaseOrderState) && Objects.equals(this.orderDetails, order.orderDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderNumber, this.purchaseOrderState, this.orderDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    purchaseOrderState: ").append(this.toIndentedString((Object)this.purchaseOrderState)).append("\n");
        sb.append("    orderDetails: ").append(this.toIndentedString(this.orderDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PurchaseOrderStateEnum {
        NEW("New"),
        ACKNOWLEDGED("Acknowledged"),
        CLOSED("Closed");

        private String value;

        private PurchaseOrderStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PurchaseOrderStateEnum fromValue(String input) {
            for (PurchaseOrderStateEnum b : PurchaseOrderStateEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PurchaseOrderStateEnum> {
            public void write(JsonWriter jsonWriter, PurchaseOrderStateEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PurchaseOrderStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PurchaseOrderStateEnum.fromValue(value);
            }
        }
    }
}

