/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.orders.v1.ItemQuantity;

@Schema(description="Details of item quantity ordered")
public class AcknowledgementStatusDetails {
    @SerializedName(value="acknowledgementDate")
    private OffsetDateTime acknowledgementDate = null;
    @SerializedName(value="acceptedQuantity")
    private ItemQuantity acceptedQuantity = null;
    @SerializedName(value="rejectedQuantity")
    private ItemQuantity rejectedQuantity = null;

    public AcknowledgementStatusDetails acknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
        return this;
    }

    @Schema(description="The date when the line item was confirmed by vendor. Must be in ISO-8601 date/time format.")
    public OffsetDateTime getAcknowledgementDate() {
        return this.acknowledgementDate;
    }

    public void setAcknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
    }

    public AcknowledgementStatusDetails acceptedQuantity(ItemQuantity acceptedQuantity) {
        this.acceptedQuantity = acceptedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getAcceptedQuantity() {
        return this.acceptedQuantity;
    }

    public void setAcceptedQuantity(ItemQuantity acceptedQuantity) {
        this.acceptedQuantity = acceptedQuantity;
    }

    public AcknowledgementStatusDetails rejectedQuantity(ItemQuantity rejectedQuantity) {
        this.rejectedQuantity = rejectedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getRejectedQuantity() {
        return this.rejectedQuantity;
    }

    public void setRejectedQuantity(ItemQuantity rejectedQuantity) {
        this.rejectedQuantity = rejectedQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgementStatusDetails acknowledgementStatusDetails = (AcknowledgementStatusDetails)o;
        return Objects.equals(this.acknowledgementDate, acknowledgementStatusDetails.acknowledgementDate) && Objects.equals(this.acceptedQuantity, acknowledgementStatusDetails.acceptedQuantity) && Objects.equals(this.rejectedQuantity, acknowledgementStatusDetails.rejectedQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.acknowledgementDate, this.acceptedQuantity, this.rejectedQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcknowledgementStatusDetails {\n");
        sb.append("    acknowledgementDate: ").append(this.toIndentedString(this.acknowledgementDate)).append("\n");
        sb.append("    acceptedQuantity: ").append(this.toIndentedString(this.acceptedQuantity)).append("\n");
        sb.append("    rejectedQuantity: ").append(this.toIndentedString(this.rejectedQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

