/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.invoices.v1.TotalWeight;

@Schema(description="Details of quantity.")
public class ItemQuantity {
    @SerializedName(value="amount")
    private Integer amount = null;
    @SerializedName(value="unitOfMeasure")
    private UnitOfMeasureEnum unitOfMeasure = null;
    @SerializedName(value="unitSize")
    private Integer unitSize = null;
    @SerializedName(value="totalWeight")
    private TotalWeight totalWeight = null;

    public ItemQuantity amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @Schema(required=true, description="Quantity of an item. This value should not be zero.")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public ItemQuantity unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(required=true, description="Unit of measure for the quantity.")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public ItemQuantity unitSize(Integer unitSize) {
        this.unitSize = unitSize;
        return this;
    }

    @Schema(description="The case size, if the unit of measure value is Cases.")
    public Integer getUnitSize() {
        return this.unitSize;
    }

    public void setUnitSize(Integer unitSize) {
        this.unitSize = unitSize;
    }

    public ItemQuantity totalWeight(TotalWeight totalWeight) {
        this.totalWeight = totalWeight;
        return this;
    }

    @Schema(description="")
    public TotalWeight getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(TotalWeight totalWeight) {
        this.totalWeight = totalWeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemQuantity itemQuantity = (ItemQuantity)o;
        return Objects.equals(this.amount, itemQuantity.amount) && Objects.equals((Object)this.unitOfMeasure, (Object)itemQuantity.unitOfMeasure) && Objects.equals(this.unitSize, itemQuantity.unitSize) && Objects.equals(this.totalWeight, itemQuantity.totalWeight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.unitOfMeasure, this.unitSize, this.totalWeight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemQuantity {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("    unitSize: ").append(this.toIndentedString(this.unitSize)).append("\n");
        sb.append("    totalWeight: ").append(this.toIndentedString(this.totalWeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitOfMeasureEnum {
        CASES("Cases"),
        EACHES("Eaches");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitOfMeasureEnum fromValue(String input) {
            for (UnitOfMeasureEnum b : UnitOfMeasureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitOfMeasureEnum> {
            public void write(JsonWriter jsonWriter, UnitOfMeasureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitOfMeasureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitOfMeasureEnum.fromValue(value);
            }
        }
    }
}

