/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.invoices.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Additional information provided by the selling party for tax-related or any other purpose.")
public class AdditionalDetails {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="detail")
    private String detail = null;
    @SerializedName(value="languageCode")
    private String languageCode = null;

    public AdditionalDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="The type of the additional information provided by the selling party.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AdditionalDetails detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Schema(required=true, description="The detail of the additional information provided by the selling party.")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public AdditionalDetails languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @Schema(description="The language code of the additional information detail.")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalDetails additionalDetails = (AdditionalDetails)o;
        return Objects.equals((Object)this.type, (Object)additionalDetails.type) && Objects.equals(this.detail, additionalDetails.detail) && Objects.equals(this.languageCode, additionalDetails.languageCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.detail, this.languageCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalDetails {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SUR("SUR"),
        OCR("OCR"),
        CARTONCOUNT("CartonCount");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

