/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.LabelData;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PartyIdentification;

@Schema(description="Shipping label information for an order, including the purchase order number, selling party, ship from party, label format, and package details.")
public class ShippingLabel {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="labelFormat")
    private LabelFormatEnum labelFormat = null;
    @SerializedName(value="labelData")
    private List<LabelData> labelData = new ArrayList<LabelData>();

    public ShippingLabel purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="This field will contain the Purchase Order Number for this order.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public ShippingLabel sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public ShippingLabel shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public ShippingLabel labelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    @Schema(required=true, description="Format of the label.")
    public LabelFormatEnum getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(LabelFormatEnum labelFormat) {
        this.labelFormat = labelFormat;
    }

    public ShippingLabel labelData(List<LabelData> labelData) {
        this.labelData = labelData;
        return this;
    }

    public ShippingLabel addLabelDataItem(LabelData labelDataItem) {
        this.labelData.add(labelDataItem);
        return this;
    }

    @Schema(required=true, description="Provides the details of the packages in this shipment.")
    public List<LabelData> getLabelData() {
        return this.labelData;
    }

    public void setLabelData(List<LabelData> labelData) {
        this.labelData = labelData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingLabel shippingLabel = (ShippingLabel)o;
        return Objects.equals(this.purchaseOrderNumber, shippingLabel.purchaseOrderNumber) && Objects.equals(this.sellingParty, shippingLabel.sellingParty) && Objects.equals(this.shipFromParty, shippingLabel.shipFromParty) && Objects.equals((Object)this.labelFormat, (Object)shippingLabel.labelFormat) && Objects.equals(this.labelData, shippingLabel.labelData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderNumber, this.sellingParty, this.shipFromParty, this.labelFormat, this.labelData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingLabel {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    labelFormat: ").append(this.toIndentedString((Object)this.labelFormat)).append("\n");
        sb.append("    labelData: ").append(this.toIndentedString(this.labelData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LabelFormatEnum {
        PNG("PNG"),
        ZPL("ZPL");

        private String value;

        private LabelFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LabelFormatEnum fromValue(String input) {
            for (LabelFormatEnum b : LabelFormatEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LabelFormatEnum> {
            public void write(JsonWriter jsonWriter, LabelFormatEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public LabelFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LabelFormatEnum.fromValue(value);
            }
        }
    }
}

