/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Details about a shipment.")
public class ShipmentDetails {
    @SerializedName(value="shippedDate")
    private OffsetDateTime shippedDate = null;
    @SerializedName(value="shipmentStatus")
    private ShipmentStatusEnum shipmentStatus = null;
    @SerializedName(value="isPriorityShipment")
    private Boolean isPriorityShipment = null;
    @SerializedName(value="vendorOrderNumber")
    private String vendorOrderNumber = null;
    @SerializedName(value="estimatedDeliveryDate")
    private OffsetDateTime estimatedDeliveryDate = null;

    public ShipmentDetails shippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
        return this;
    }

    @Schema(required=true, description="The date of the shipment's departure from vendor's location. Vendors send ASNs within 30 minutes of departure from their warehouse/distribution center or six hours prior to the appointment time at the Amazon destination warehouse. The shipped date mentioned in the shipment confirmation cannot be in the future.")
    public OffsetDateTime getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
    }

    public ShipmentDetails shipmentStatus(ShipmentStatusEnum shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @Schema(required=true, description="The shipment status.")
    public ShipmentStatusEnum getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(ShipmentStatusEnum shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public ShipmentDetails isPriorityShipment(Boolean isPriorityShipment) {
        this.isPriorityShipment = isPriorityShipment;
        return this;
    }

    @Schema(description="Provide the priority of the shipment.")
    public Boolean isIsPriorityShipment() {
        return this.isPriorityShipment;
    }

    public void setIsPriorityShipment(Boolean isPriorityShipment) {
        this.isPriorityShipment = isPriorityShipment;
    }

    public ShipmentDetails vendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
        return this;
    }

    @Schema(description="The vendor order number is a unique identifier generated by a vendor for their reference.")
    public String getVendorOrderNumber() {
        return this.vendorOrderNumber;
    }

    public void setVendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
    }

    public ShipmentDetails estimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
        return this;
    }

    @Schema(description="The date on which the shipment is expected to reach the buyer's warehouse. The date is estimated based on the average transit time between the ship-from location and the destination. Usually, the exact appointment time is unknown when creating the shipment confirmation and is later provided by the buyer.")
    public OffsetDateTime getEstimatedDeliveryDate() {
        return this.estimatedDeliveryDate;
    }

    public void setEstimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDetails shipmentDetails = (ShipmentDetails)o;
        return Objects.equals(this.shippedDate, shipmentDetails.shippedDate) && Objects.equals((Object)this.shipmentStatus, (Object)shipmentDetails.shipmentStatus) && Objects.equals(this.isPriorityShipment, shipmentDetails.isPriorityShipment) && Objects.equals(this.vendorOrderNumber, shipmentDetails.vendorOrderNumber) && Objects.equals(this.estimatedDeliveryDate, shipmentDetails.estimatedDeliveryDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shippedDate, this.shipmentStatus, this.isPriorityShipment, this.vendorOrderNumber, this.estimatedDeliveryDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDetails {\n");
        sb.append("    shippedDate: ").append(this.toIndentedString(this.shippedDate)).append("\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    isPriorityShipment: ").append(this.toIndentedString(this.isPriorityShipment)).append("\n");
        sb.append("    vendorOrderNumber: ").append(this.toIndentedString(this.vendorOrderNumber)).append("\n");
        sb.append("    estimatedDeliveryDate: ").append(this.toIndentedString(this.estimatedDeliveryDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentStatusEnum {
        SHIPPED("SHIPPED"),
        FLOOR_DENIAL("FLOOR_DENIAL");

        private String value;

        private ShipmentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentStatusEnum fromValue(String input) {
            for (ShipmentStatusEnum b : ShipmentStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentStatusEnum> {
            public void write(JsonWriter jsonWriter, ShipmentStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentStatusEnum.fromValue(value);
            }
        }
    }
}

