/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.ItemQuantity;

@Schema(description="An item that has been packed into a container for shipping.")
public class PackedItem {
    @SerializedName(value="itemSequenceNumber")
    private Integer itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="pieceNumber")
    private Integer pieceNumber = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="packedQuantity")
    private ItemQuantity packedQuantity = null;

    public PackedItem itemSequenceNumber(Integer itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="The sequence number of the item. The number must be the same as the order number of the item.")
    public Integer getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(Integer itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public PackedItem buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="The buyer's Amazon Standard Identification Number (ASIN) of an item. Either `buyerProductIdentifier` or `vendorProductIdentifier` is required.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public PackedItem pieceNumber(Integer pieceNumber) {
        this.pieceNumber = pieceNumber;
        return this;
    }

    @Schema(description="The piece number of the item in this container. This is required when the item is split across different containers.")
    public Integer getPieceNumber() {
        return this.pieceNumber;
    }

    public void setPieceNumber(Integer pieceNumber) {
        this.pieceNumber = pieceNumber;
    }

    public PackedItem vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="An item's product identifier, which the vendor selects. This identifier should be the same as the identifier, such as a SKU, in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public PackedItem packedQuantity(ItemQuantity packedQuantity) {
        this.packedQuantity = packedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getPackedQuantity() {
        return this.packedQuantity;
    }

    public void setPackedQuantity(ItemQuantity packedQuantity) {
        this.packedQuantity = packedQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedItem packedItem = (PackedItem)o;
        return Objects.equals(this.itemSequenceNumber, packedItem.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, packedItem.buyerProductIdentifier) && Objects.equals(this.pieceNumber, packedItem.pieceNumber) && Objects.equals(this.vendorProductIdentifier, packedItem.vendorProductIdentifier) && Objects.equals(this.packedQuantity, packedItem.packedQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.pieceNumber, this.vendorProductIdentifier, this.packedQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackedItem {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    pieceNumber: ").append(this.toIndentedString(this.pieceNumber)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    packedQuantity: ").append(this.toIndentedString(this.packedQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

