/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.payments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.payments.v1.Money;

@Schema(description="Details of tax amount applied.")
public class TaxDetail {
    @SerializedName(value="taxType")
    private TaxTypeEnum taxType = null;
    @SerializedName(value="taxRate")
    private String taxRate = null;
    @SerializedName(value="taxAmount")
    private Money taxAmount = null;
    @SerializedName(value="taxableAmount")
    private Money taxableAmount = null;

    public TaxDetail taxType(TaxTypeEnum taxType) {
        this.taxType = taxType;
        return this;
    }

    @Schema(required=true, description="Type of the tax applied.")
    public TaxTypeEnum getTaxType() {
        return this.taxType;
    }

    public void setTaxType(TaxTypeEnum taxType) {
        this.taxType = taxType;
    }

    public TaxDetail taxRate(String taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Schema(description="")
    public String getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public TaxDetail taxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Money getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Money taxAmount) {
        this.taxAmount = taxAmount;
    }

    public TaxDetail taxableAmount(Money taxableAmount) {
        this.taxableAmount = taxableAmount;
        return this;
    }

    @Schema(description="")
    public Money getTaxableAmount() {
        return this.taxableAmount;
    }

    public void setTaxableAmount(Money taxableAmount) {
        this.taxableAmount = taxableAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxDetail taxDetail = (TaxDetail)o;
        return Objects.equals((Object)this.taxType, (Object)taxDetail.taxType) && Objects.equals(this.taxRate, taxDetail.taxRate) && Objects.equals(this.taxAmount, taxDetail.taxAmount) && Objects.equals(this.taxableAmount, taxDetail.taxableAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taxType, this.taxRate, this.taxAmount, this.taxableAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxDetail {\n");
        sb.append("    taxType: ").append(this.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxableAmount: ").append(this.toIndentedString(this.taxableAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxTypeEnum {
        CGST("CGST"),
        SGST("SGST"),
        CESS("CESS"),
        UTGST("UTGST"),
        IGST("IGST"),
        MWST_("MwSt."),
        PST("PST"),
        TVA("TVA"),
        VAT("VAT"),
        GST("GST"),
        ST("ST"),
        CONSUMPTION("Consumption"),
        MUTUALLYDEFINED("MutuallyDefined"),
        DOMESTICVAT("DomesticVAT");

        private String value;

        private TaxTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxTypeEnum fromValue(String input) {
            for (TaxTypeEnum b : TaxTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TaxTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TaxTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxTypeEnum.fromValue(value);
            }
        }
    }
}

