/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.ShipmentDates;

@Schema(description="Shipment details required for the shipment.")
public class ShipmentDetails {
    @SerializedName(value="isPriorityShipment")
    private Boolean isPriorityShipment = null;
    @SerializedName(value="isScheduledDeliveryShipment")
    private Boolean isScheduledDeliveryShipment = null;
    @SerializedName(value="isPslipRequired")
    private Boolean isPslipRequired = null;
    @SerializedName(value="isGift")
    private Boolean isGift = null;
    @SerializedName(value="shipMethod")
    private String shipMethod = null;
    @SerializedName(value="shipmentDates")
    private ShipmentDates shipmentDates = null;
    @SerializedName(value="messageToCustomer")
    private String messageToCustomer = null;

    public ShipmentDetails isPriorityShipment(Boolean isPriorityShipment) {
        this.isPriorityShipment = isPriorityShipment;
        return this;
    }

    @Schema(required=true, description="When true, this is a priority shipment.")
    public Boolean isIsPriorityShipment() {
        return this.isPriorityShipment;
    }

    public void setIsPriorityShipment(Boolean isPriorityShipment) {
        this.isPriorityShipment = isPriorityShipment;
    }

    public ShipmentDetails isScheduledDeliveryShipment(Boolean isScheduledDeliveryShipment) {
        this.isScheduledDeliveryShipment = isScheduledDeliveryShipment;
        return this;
    }

    @Schema(description="When true, this order is part of a scheduled delivery program.")
    public Boolean isIsScheduledDeliveryShipment() {
        return this.isScheduledDeliveryShipment;
    }

    public void setIsScheduledDeliveryShipment(Boolean isScheduledDeliveryShipment) {
        this.isScheduledDeliveryShipment = isScheduledDeliveryShipment;
    }

    public ShipmentDetails isPslipRequired(Boolean isPslipRequired) {
        this.isPslipRequired = isPslipRequired;
        return this;
    }

    @Schema(required=true, description="When true, a packing slip is required to be sent to the customer.")
    public Boolean isIsPslipRequired() {
        return this.isPslipRequired;
    }

    public void setIsPslipRequired(Boolean isPslipRequired) {
        this.isPslipRequired = isPslipRequired;
    }

    public ShipmentDetails isGift(Boolean isGift) {
        this.isGift = isGift;
        return this;
    }

    @Schema(description="When true, the order contain a gift. Include the gift message and gift wrap information.")
    public Boolean isIsGift() {
        return this.isGift;
    }

    public void setIsGift(Boolean isGift) {
        this.isGift = isGift;
    }

    public ShipmentDetails shipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
        return this;
    }

    @Schema(required=true, description="Ship method to be used for shipping the order. Amazon defines ship method codes indicating the shipping carrier and shipment service level. To see the full list of ship methods in use, including both the code and the friendly name, search the 'Help' section on Vendor Central for 'ship methods'.")
    public String getShipMethod() {
        return this.shipMethod;
    }

    public void setShipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
    }

    public ShipmentDetails shipmentDates(ShipmentDates shipmentDates) {
        this.shipmentDates = shipmentDates;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentDates getShipmentDates() {
        return this.shipmentDates;
    }

    public void setShipmentDates(ShipmentDates shipmentDates) {
        this.shipmentDates = shipmentDates;
    }

    public ShipmentDetails messageToCustomer(String messageToCustomer) {
        this.messageToCustomer = messageToCustomer;
        return this;
    }

    @Schema(required=true, description="Message to customer for order status.")
    public String getMessageToCustomer() {
        return this.messageToCustomer;
    }

    public void setMessageToCustomer(String messageToCustomer) {
        this.messageToCustomer = messageToCustomer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDetails shipmentDetails = (ShipmentDetails)o;
        return Objects.equals(this.isPriorityShipment, shipmentDetails.isPriorityShipment) && Objects.equals(this.isScheduledDeliveryShipment, shipmentDetails.isScheduledDeliveryShipment) && Objects.equals(this.isPslipRequired, shipmentDetails.isPslipRequired) && Objects.equals(this.isGift, shipmentDetails.isGift) && Objects.equals(this.shipMethod, shipmentDetails.shipMethod) && Objects.equals(this.shipmentDates, shipmentDetails.shipmentDates) && Objects.equals(this.messageToCustomer, shipmentDetails.messageToCustomer);
    }

    public int hashCode() {
        return Objects.hash(this.isPriorityShipment, this.isScheduledDeliveryShipment, this.isPslipRequired, this.isGift, this.shipMethod, this.shipmentDates, this.messageToCustomer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDetails {\n");
        sb.append("    isPriorityShipment: ").append(this.toIndentedString(this.isPriorityShipment)).append("\n");
        sb.append("    isScheduledDeliveryShipment: ").append(this.toIndentedString(this.isScheduledDeliveryShipment)).append("\n");
        sb.append("    isPslipRequired: ").append(this.toIndentedString(this.isPslipRequired)).append("\n");
        sb.append("    isGift: ").append(this.toIndentedString(this.isGift)).append("\n");
        sb.append("    shipMethod: ").append(this.toIndentedString(this.shipMethod)).append("\n");
        sb.append("    shipmentDates: ").append(this.toIndentedString(this.shipmentDates)).append("\n");
        sb.append("    messageToCustomer: ").append(this.toIndentedString(this.messageToCustomer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

