/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Shipment dates.")
public class ShipmentDates {
    @SerializedName(value="requiredShipDate")
    private OffsetDateTime requiredShipDate = null;
    @SerializedName(value="promisedDeliveryDate")
    private OffsetDateTime promisedDeliveryDate = null;

    public ShipmentDates requiredShipDate(OffsetDateTime requiredShipDate) {
        this.requiredShipDate = requiredShipDate;
        return this;
    }

    @Schema(required=true, description="Time by which the vendor is required to ship the order.")
    public OffsetDateTime getRequiredShipDate() {
        return this.requiredShipDate;
    }

    public void setRequiredShipDate(OffsetDateTime requiredShipDate) {
        this.requiredShipDate = requiredShipDate;
    }

    public ShipmentDates promisedDeliveryDate(OffsetDateTime promisedDeliveryDate) {
        this.promisedDeliveryDate = promisedDeliveryDate;
        return this;
    }

    @Schema(description="Delivery date promised to the Amazon customer.")
    public OffsetDateTime getPromisedDeliveryDate() {
        return this.promisedDeliveryDate;
    }

    public void setPromisedDeliveryDate(OffsetDateTime promisedDeliveryDate) {
        this.promisedDeliveryDate = promisedDeliveryDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDates shipmentDates = (ShipmentDates)o;
        return Objects.equals(this.requiredShipDate, shipmentDates.requiredShipDate) && Objects.equals(this.promisedDeliveryDate, shipmentDates.promisedDeliveryDate);
    }

    public int hashCode() {
        return Objects.hash(this.requiredShipDate, this.promisedDeliveryDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDates {\n");
        sb.append("    requiredShipDate: ").append(this.toIndentedString(this.requiredShipDate)).append("\n");
        sb.append("    promisedDeliveryDate: ").append(this.toIndentedString(this.promisedDeliveryDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

