/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.Address;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.OrderItem;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.PartyIdentification;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.ShipmentDetails;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.TaxItemDetails;

@Schema(description="Details of an order.")
public class OrderDetails {
    @SerializedName(value="customerOrderNumber")
    private String customerOrderNumber = null;
    @SerializedName(value="orderDate")
    private OffsetDateTime orderDate = null;
    @SerializedName(value="orderStatus")
    private OrderStatusEnum orderStatus = null;
    @SerializedName(value="shipmentDetails")
    private ShipmentDetails shipmentDetails = null;
    @SerializedName(value="taxTotal")
    private TaxItemDetails taxTotal = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="shipToParty")
    private Address shipToParty = null;
    @SerializedName(value="billToParty")
    private PartyIdentification billToParty = null;
    @SerializedName(value="hasCustomizableItems")
    private Boolean hasCustomizableItems = null;
    @SerializedName(value="items")
    private List<OrderItem> items = new ArrayList<OrderItem>();

    public OrderDetails customerOrderNumber(String customerOrderNumber) {
        this.customerOrderNumber = customerOrderNumber;
        return this;
    }

    @Schema(required=true, description="The customer order number.")
    public String getCustomerOrderNumber() {
        return this.customerOrderNumber;
    }

    public void setCustomerOrderNumber(String customerOrderNumber) {
        this.customerOrderNumber = customerOrderNumber;
    }

    public OrderDetails orderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(required=true, description="The date the order was placed. This  field is expected to be in ISO-8601 date/time format, for example:2018-07-16T23:00:00Z/ 2018-07-16T23:00:00-05:00 /2018-07-16T23:00:00-08:00. If no time zone is specified, UTC should be assumed.")
    public OffsetDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public OrderDetails orderStatus(OrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @Schema(description="Current status of the order.")
    public OrderStatusEnum getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(OrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public OrderDetails shipmentDetails(ShipmentDetails shipmentDetails) {
        this.shipmentDetails = shipmentDetails;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentDetails getShipmentDetails() {
        return this.shipmentDetails;
    }

    public void setShipmentDetails(ShipmentDetails shipmentDetails) {
        this.shipmentDetails = shipmentDetails;
    }

    public OrderDetails taxTotal(TaxItemDetails taxTotal) {
        this.taxTotal = taxTotal;
        return this;
    }

    @Schema(description="")
    public TaxItemDetails getTaxTotal() {
        return this.taxTotal;
    }

    public void setTaxTotal(TaxItemDetails taxTotal) {
        this.taxTotal = taxTotal;
    }

    public OrderDetails sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public OrderDetails shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public OrderDetails shipToParty(Address shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(Address shipToParty) {
        this.shipToParty = shipToParty;
    }

    public OrderDetails billToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getBillToParty() {
        return this.billToParty;
    }

    public void setBillToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
    }

    public OrderDetails hasCustomizableItems(Boolean hasCustomizableItems) {
        this.hasCustomizableItems = hasCustomizableItems;
        return this;
    }

    @Schema(description="When `true`, the order contains customizable items.")
    public Boolean isHasCustomizableItems() {
        return this.hasCustomizableItems;
    }

    public void setHasCustomizableItems(Boolean hasCustomizableItems) {
        this.hasCustomizableItems = hasCustomizableItems;
    }

    public OrderDetails items(List<OrderItem> items) {
        this.items = items;
        return this;
    }

    public OrderDetails addItemsItem(OrderItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of items in this purchase order.")
    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDetails orderDetails = (OrderDetails)o;
        return Objects.equals(this.customerOrderNumber, orderDetails.customerOrderNumber) && Objects.equals(this.orderDate, orderDetails.orderDate) && Objects.equals((Object)this.orderStatus, (Object)orderDetails.orderStatus) && Objects.equals(this.shipmentDetails, orderDetails.shipmentDetails) && Objects.equals(this.taxTotal, orderDetails.taxTotal) && Objects.equals(this.sellingParty, orderDetails.sellingParty) && Objects.equals(this.shipFromParty, orderDetails.shipFromParty) && Objects.equals(this.shipToParty, orderDetails.shipToParty) && Objects.equals(this.billToParty, orderDetails.billToParty) && Objects.equals(this.hasCustomizableItems, orderDetails.hasCustomizableItems) && Objects.equals(this.items, orderDetails.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customerOrderNumber, this.orderDate, this.orderStatus, this.shipmentDetails, this.taxTotal, this.sellingParty, this.shipFromParty, this.shipToParty, this.billToParty, this.hasCustomizableItems, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderDetails {\n");
        sb.append("    customerOrderNumber: ").append(this.toIndentedString(this.customerOrderNumber)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderStatus: ").append(this.toIndentedString((Object)this.orderStatus)).append("\n");
        sb.append("    shipmentDetails: ").append(this.toIndentedString(this.shipmentDetails)).append("\n");
        sb.append("    taxTotal: ").append(this.toIndentedString(this.taxTotal)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    billToParty: ").append(this.toIndentedString(this.billToParty)).append("\n");
        sb.append("    hasCustomizableItems: ").append(this.toIndentedString(this.hasCustomizableItems)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrderStatusEnum {
        NEW("NEW"),
        SHIPPED("SHIPPED"),
        ACCEPTED("ACCEPTED"),
        CANCELLED("CANCELLED");

        private String value;

        private OrderStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrderStatusEnum fromValue(String input) {
            for (OrderStatusEnum b : OrderStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrderStatusEnum> {
            public void write(JsonWriter jsonWriter, OrderStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public OrderStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrderStatusEnum.fromValue(value);
            }
        }
    }
}

