/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.tokens.v2021_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.tokens.v2021_03_01.RestrictedResource;

@Schema(description="The request schema for the createRestrictedDataToken operation.")
public class CreateRestrictedDataTokenRequest {
    @SerializedName(value="targetApplication")
    private String targetApplication = null;
    @SerializedName(value="restrictedResources")
    private List<RestrictedResource> restrictedResources = new ArrayList<RestrictedResource>();

    public CreateRestrictedDataTokenRequest targetApplication(String targetApplication) {
        this.targetApplication = targetApplication;
        return this;
    }

    @Schema(description="The application ID for the target application to which access is being delegated.")
    public String getTargetApplication() {
        return this.targetApplication;
    }

    public void setTargetApplication(String targetApplication) {
        this.targetApplication = targetApplication;
    }

    public CreateRestrictedDataTokenRequest restrictedResources(List<RestrictedResource> restrictedResources) {
        this.restrictedResources = restrictedResources;
        return this;
    }

    public CreateRestrictedDataTokenRequest addRestrictedResourcesItem(RestrictedResource restrictedResourcesItem) {
        this.restrictedResources.add(restrictedResourcesItem);
        return this;
    }

    @Schema(required=true, description="A list of restricted resources. Maximum: 50")
    public List<RestrictedResource> getRestrictedResources() {
        return this.restrictedResources;
    }

    public void setRestrictedResources(List<RestrictedResource> restrictedResources) {
        this.restrictedResources = restrictedResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRestrictedDataTokenRequest createRestrictedDataTokenRequest = (CreateRestrictedDataTokenRequest)o;
        return Objects.equals(this.targetApplication, createRestrictedDataTokenRequest.targetApplication) && Objects.equals(this.restrictedResources, createRestrictedDataTokenRequest.restrictedResources);
    }

    public int hashCode() {
        return Objects.hash(this.targetApplication, this.restrictedResources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRestrictedDataTokenRequest {\n");
        sb.append("    targetApplication: ").append(this.toIndentedString(this.targetApplication)).append("\n");
        sb.append("    restrictedResources: ").append(this.toIndentedString(this.restrictedResources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

