/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.shipping.v2.AccessPointDetails;
import software.amazon.spapi.models.shipping.v2.Address;
import software.amazon.spapi.models.shipping.v2.ChannelDetails;
import software.amazon.spapi.models.shipping.v2.GoodsOwner;
import software.amazon.spapi.models.shipping.v2.OneClickShipmentValueAddedServiceDetails;
import software.amazon.spapi.models.shipping.v2.PackageList;
import software.amazon.spapi.models.shipping.v2.RequestedDocumentSpecification;
import software.amazon.spapi.models.shipping.v2.ServiceSelection;
import software.amazon.spapi.models.shipping.v2.ShipperInstruction;
import software.amazon.spapi.models.shipping.v2.TaxDetailList;

@Schema(description="The request schema for the OneClickShipment operation. When the channelType is not Amazon, shipTo is required and when channelType is Amazon shipTo is ignored.")
public class OneClickShipmentRequest {
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="returnTo")
    private Address returnTo = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="goodsOwner")
    private GoodsOwner goodsOwner = null;
    @SerializedName(value="packages")
    private PackageList packages = null;
    @SerializedName(value="valueAddedServicesDetails")
    private OneClickShipmentValueAddedServiceDetails valueAddedServicesDetails = null;
    @SerializedName(value="taxDetails")
    private TaxDetailList taxDetails = null;
    @SerializedName(value="channelDetails")
    private ChannelDetails channelDetails = null;
    @SerializedName(value="labelSpecifications")
    private RequestedDocumentSpecification labelSpecifications = null;
    @SerializedName(value="serviceSelection")
    private ServiceSelection serviceSelection = null;
    @SerializedName(value="shipperInstruction")
    private ShipperInstruction shipperInstruction = null;
    @SerializedName(value="destinationAccessPointDetails")
    private AccessPointDetails destinationAccessPointDetails = null;

    public OneClickShipmentRequest shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @Schema(description="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public OneClickShipmentRequest shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public OneClickShipmentRequest returnTo(Address returnTo) {
        this.returnTo = returnTo;
        return this;
    }

    @Schema(description="")
    public Address getReturnTo() {
        return this.returnTo;
    }

    public void setReturnTo(Address returnTo) {
        this.returnTo = returnTo;
    }

    public OneClickShipmentRequest shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(description="The ship date and time (the requested pickup). This defaults to the current date and time.")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public OneClickShipmentRequest goodsOwner(GoodsOwner goodsOwner) {
        this.goodsOwner = goodsOwner;
        return this;
    }

    @Schema(description="")
    public GoodsOwner getGoodsOwner() {
        return this.goodsOwner;
    }

    public void setGoodsOwner(GoodsOwner goodsOwner) {
        this.goodsOwner = goodsOwner;
    }

    public OneClickShipmentRequest packages(PackageList packages) {
        this.packages = packages;
        return this;
    }

    @Schema(required=true, description="")
    public PackageList getPackages() {
        return this.packages;
    }

    public void setPackages(PackageList packages) {
        this.packages = packages;
    }

    public OneClickShipmentRequest valueAddedServicesDetails(OneClickShipmentValueAddedServiceDetails valueAddedServicesDetails) {
        this.valueAddedServicesDetails = valueAddedServicesDetails;
        return this;
    }

    @Schema(description="")
    public OneClickShipmentValueAddedServiceDetails getValueAddedServicesDetails() {
        return this.valueAddedServicesDetails;
    }

    public void setValueAddedServicesDetails(OneClickShipmentValueAddedServiceDetails valueAddedServicesDetails) {
        this.valueAddedServicesDetails = valueAddedServicesDetails;
    }

    public OneClickShipmentRequest taxDetails(TaxDetailList taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    @Schema(description="")
    public TaxDetailList getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(TaxDetailList taxDetails) {
        this.taxDetails = taxDetails;
    }

    public OneClickShipmentRequest channelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
        return this;
    }

    @Schema(required=true, description="")
    public ChannelDetails getChannelDetails() {
        return this.channelDetails;
    }

    public void setChannelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
    }

    public OneClickShipmentRequest labelSpecifications(RequestedDocumentSpecification labelSpecifications) {
        this.labelSpecifications = labelSpecifications;
        return this;
    }

    @Schema(required=true, description="")
    public RequestedDocumentSpecification getLabelSpecifications() {
        return this.labelSpecifications;
    }

    public void setLabelSpecifications(RequestedDocumentSpecification labelSpecifications) {
        this.labelSpecifications = labelSpecifications;
    }

    public OneClickShipmentRequest serviceSelection(ServiceSelection serviceSelection) {
        this.serviceSelection = serviceSelection;
        return this;
    }

    @Schema(required=true, description="")
    public ServiceSelection getServiceSelection() {
        return this.serviceSelection;
    }

    public void setServiceSelection(ServiceSelection serviceSelection) {
        this.serviceSelection = serviceSelection;
    }

    public OneClickShipmentRequest shipperInstruction(ShipperInstruction shipperInstruction) {
        this.shipperInstruction = shipperInstruction;
        return this;
    }

    @Schema(description="")
    public ShipperInstruction getShipperInstruction() {
        return this.shipperInstruction;
    }

    public void setShipperInstruction(ShipperInstruction shipperInstruction) {
        this.shipperInstruction = shipperInstruction;
    }

    public OneClickShipmentRequest destinationAccessPointDetails(AccessPointDetails destinationAccessPointDetails) {
        this.destinationAccessPointDetails = destinationAccessPointDetails;
        return this;
    }

    @Schema(description="")
    public AccessPointDetails getDestinationAccessPointDetails() {
        return this.destinationAccessPointDetails;
    }

    public void setDestinationAccessPointDetails(AccessPointDetails destinationAccessPointDetails) {
        this.destinationAccessPointDetails = destinationAccessPointDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneClickShipmentRequest oneClickShipmentRequest = (OneClickShipmentRequest)o;
        return Objects.equals(this.shipTo, oneClickShipmentRequest.shipTo) && Objects.equals(this.shipFrom, oneClickShipmentRequest.shipFrom) && Objects.equals(this.returnTo, oneClickShipmentRequest.returnTo) && Objects.equals(this.shipDate, oneClickShipmentRequest.shipDate) && Objects.equals(this.goodsOwner, oneClickShipmentRequest.goodsOwner) && Objects.equals(this.packages, oneClickShipmentRequest.packages) && Objects.equals(this.valueAddedServicesDetails, oneClickShipmentRequest.valueAddedServicesDetails) && Objects.equals(this.taxDetails, oneClickShipmentRequest.taxDetails) && Objects.equals(this.channelDetails, oneClickShipmentRequest.channelDetails) && Objects.equals(this.labelSpecifications, oneClickShipmentRequest.labelSpecifications) && Objects.equals(this.serviceSelection, oneClickShipmentRequest.serviceSelection) && Objects.equals(this.shipperInstruction, oneClickShipmentRequest.shipperInstruction) && Objects.equals(this.destinationAccessPointDetails, oneClickShipmentRequest.destinationAccessPointDetails);
    }

    public int hashCode() {
        return Objects.hash(this.shipTo, this.shipFrom, this.returnTo, this.shipDate, this.goodsOwner, this.packages, this.valueAddedServicesDetails, this.taxDetails, this.channelDetails, this.labelSpecifications, this.serviceSelection, this.shipperInstruction, this.destinationAccessPointDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OneClickShipmentRequest {\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    returnTo: ").append(this.toIndentedString(this.returnTo)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    goodsOwner: ").append(this.toIndentedString(this.goodsOwner)).append("\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    valueAddedServicesDetails: ").append(this.toIndentedString(this.valueAddedServicesDetails)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    channelDetails: ").append(this.toIndentedString(this.channelDetails)).append("\n");
        sb.append("    labelSpecifications: ").append(this.toIndentedString(this.labelSpecifications)).append("\n");
        sb.append("    serviceSelection: ").append(this.toIndentedString(this.serviceSelection)).append("\n");
        sb.append("    shipperInstruction: ").append(this.toIndentedString(this.shipperInstruction)).append("\n");
        sb.append("    destinationAccessPointDetails: ").append(this.toIndentedString(this.destinationAccessPointDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

