/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Additional information required for the NDR action that has been filed. If the NDR Action is RESCHEDULE, rescheduleDate is a required field. Otherwise, if the NDR Action is REATTEMPT, additionalAddressNotes is a required field. ")
public class NdrRequestData {
    @SerializedName(value="rescheduleDate")
    private OffsetDateTime rescheduleDate = null;
    @SerializedName(value="additionalAddressNotes")
    private String additionalAddressNotes = null;

    public NdrRequestData rescheduleDate(OffsetDateTime rescheduleDate) {
        this.rescheduleDate = rescheduleDate;
        return this;
    }

    @Schema(example="2023-12-12T05:24Z", description="The date on which the Seller wants to reschedule shipment delivery, in ISO-8601 date/time format")
    public OffsetDateTime getRescheduleDate() {
        return this.rescheduleDate;
    }

    public void setRescheduleDate(OffsetDateTime rescheduleDate) {
        this.rescheduleDate = rescheduleDate;
    }

    public NdrRequestData additionalAddressNotes(String additionalAddressNotes) {
        this.additionalAddressNotes = additionalAddressNotes;
        return this;
    }

    @Schema(description="")
    public String getAdditionalAddressNotes() {
        return this.additionalAddressNotes;
    }

    public void setAdditionalAddressNotes(String additionalAddressNotes) {
        this.additionalAddressNotes = additionalAddressNotes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NdrRequestData ndrRequestData = (NdrRequestData)o;
        return Objects.equals(this.rescheduleDate, ndrRequestData.rescheduleDate) && Objects.equals(this.additionalAddressNotes, ndrRequestData.additionalAddressNotes);
    }

    public int hashCode() {
        return Objects.hash(this.rescheduleDate, this.additionalAddressNotes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NdrRequestData {\n");
        sb.append("    rescheduleDate: ").append(this.toIndentedString(this.rescheduleDate)).append("\n");
        sb.append("    additionalAddressNotes: ").append(this.toIndentedString(this.additionalAddressNotes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

