/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.ChargeList;
import software.amazon.spapi.models.shipping.v2.Currency;
import software.amazon.spapi.models.shipping.v2.Dimensions;
import software.amazon.spapi.models.shipping.v2.ItemList;
import software.amazon.spapi.models.shipping.v2.Weight;

@Schema(description="A package to be shipped through a shipping service offering.")
public class ModelPackage {
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="insuredValue")
    private Currency insuredValue = null;
    @SerializedName(value="isHazmat")
    private Boolean isHazmat = null;
    @SerializedName(value="sellerDisplayName")
    private String sellerDisplayName = null;
    @SerializedName(value="charges")
    private ChargeList charges = null;
    @SerializedName(value="packageClientReferenceId")
    private String packageClientReferenceId = null;
    @SerializedName(value="items")
    private ItemList items = null;

    public ModelPackage dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(required=true, description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public ModelPackage weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(required=true, description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public ModelPackage insuredValue(Currency insuredValue) {
        this.insuredValue = insuredValue;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getInsuredValue() {
        return this.insuredValue;
    }

    public void setInsuredValue(Currency insuredValue) {
        this.insuredValue = insuredValue;
    }

    public ModelPackage isHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
        return this;
    }

    @Schema(description="When true, the package contains hazardous materials. Defaults to false.")
    public Boolean isIsHazmat() {
        return this.isHazmat;
    }

    public void setIsHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
    }

    public ModelPackage sellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
        return this;
    }

    @Schema(description="The seller name displayed on the label.")
    public String getSellerDisplayName() {
        return this.sellerDisplayName;
    }

    public void setSellerDisplayName(String sellerDisplayName) {
        this.sellerDisplayName = sellerDisplayName;
    }

    public ModelPackage charges(ChargeList charges) {
        this.charges = charges;
        return this;
    }

    @Schema(description="")
    public ChargeList getCharges() {
        return this.charges;
    }

    public void setCharges(ChargeList charges) {
        this.charges = charges;
    }

    public ModelPackage packageClientReferenceId(String packageClientReferenceId) {
        this.packageClientReferenceId = packageClientReferenceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getPackageClientReferenceId() {
        return this.packageClientReferenceId;
    }

    public void setPackageClientReferenceId(String packageClientReferenceId) {
        this.packageClientReferenceId = packageClientReferenceId;
    }

    public ModelPackage items(ItemList items) {
        this.items = items;
        return this;
    }

    @Schema(required=true, description="")
    public ItemList getItems() {
        return this.items;
    }

    public void setItems(ItemList items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPackage _package = (ModelPackage)o;
        return Objects.equals(this.dimensions, _package.dimensions) && Objects.equals(this.weight, _package.weight) && Objects.equals(this.insuredValue, _package.insuredValue) && Objects.equals(this.isHazmat, _package.isHazmat) && Objects.equals(this.sellerDisplayName, _package.sellerDisplayName) && Objects.equals(this.charges, _package.charges) && Objects.equals(this.packageClientReferenceId, _package.packageClientReferenceId) && Objects.equals(this.items, _package.items);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.weight, this.insuredValue, this.isHazmat, this.sellerDisplayName, this.charges, this.packageClientReferenceId, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelPackage {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    insuredValue: ").append(this.toIndentedString(this.insuredValue)).append("\n");
        sb.append("    isHazmat: ").append(this.toIndentedString(this.isHazmat)).append("\n");
        sb.append("    sellerDisplayName: ").append(this.toIndentedString(this.sellerDisplayName)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    packageClientReferenceId: ").append(this.toIndentedString(this.packageClientReferenceId)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

