/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="The invoice details for charges associated with the goods in the package. Only applies to certain regions.")
public class InvoiceDetails {
    @SerializedName(value="invoiceNumber")
    private String invoiceNumber = null;
    @SerializedName(value="invoiceDate")
    private OffsetDateTime invoiceDate = null;

    public InvoiceDetails invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @Schema(description="The invoice number of the item.")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public InvoiceDetails invoiceDate(OffsetDateTime invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    @Schema(description="The invoice date of the item in ISO 8061 format.")
    public OffsetDateTime getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(OffsetDateTime invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceDetails invoiceDetails = (InvoiceDetails)o;
        return Objects.equals(this.invoiceNumber, invoiceDetails.invoiceNumber) && Objects.equals(this.invoiceDate, invoiceDetails.invoiceDate);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceNumber, this.invoiceDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceDetails {\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    invoiceDate: ").append(this.toIndentedString(this.invoiceDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

