/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="The monetary value in the currency indicated, in ISO 4217 standard format.")
public class Currency {
    @SerializedName(value="value")
    private BigDecimal value = null;
    @SerializedName(value="unit")
    private String unit = null;

    public Currency value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="The monetary value.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public Currency unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(required=true, description="The ISO 4217 format 3-character currency code.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Currency currency = (Currency)o;
        return Objects.equals(this.value, currency.value) && Objects.equals(this.unit, currency.unit);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Currency {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

