/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.ValueAddedService;

@Schema(description="The value-added services available for purchase with a shipping service offering.")
public class AvailableValueAddedServiceGroup {
    @SerializedName(value="groupId")
    private String groupId = null;
    @SerializedName(value="groupDescription")
    private String groupDescription = null;
    @SerializedName(value="isRequired")
    private Boolean isRequired = null;
    @SerializedName(value="valueAddedServices")
    private List<ValueAddedService> valueAddedServices = null;

    public AvailableValueAddedServiceGroup groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(required=true, description="The type of the value-added service group.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public AvailableValueAddedServiceGroup groupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
        return this;
    }

    @Schema(required=true, description="The name of the value-added service group.")
    public String getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public AvailableValueAddedServiceGroup isRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @Schema(required=true, description="When true, one or more of the value-added services listed must be specified.")
    public Boolean isIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public AvailableValueAddedServiceGroup valueAddedServices(List<ValueAddedService> valueAddedServices) {
        this.valueAddedServices = valueAddedServices;
        return this;
    }

    public AvailableValueAddedServiceGroup addValueAddedServicesItem(ValueAddedService valueAddedServicesItem) {
        if (this.valueAddedServices == null) {
            this.valueAddedServices = new ArrayList<ValueAddedService>();
        }
        this.valueAddedServices.add(valueAddedServicesItem);
        return this;
    }

    @Schema(description="A list of optional value-added services available for purchase with a shipping service offering.")
    public List<ValueAddedService> getValueAddedServices() {
        return this.valueAddedServices;
    }

    public void setValueAddedServices(List<ValueAddedService> valueAddedServices) {
        this.valueAddedServices = valueAddedServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableValueAddedServiceGroup availableValueAddedServiceGroup = (AvailableValueAddedServiceGroup)o;
        return Objects.equals(this.groupId, availableValueAddedServiceGroup.groupId) && Objects.equals(this.groupDescription, availableValueAddedServiceGroup.groupDescription) && Objects.equals(this.isRequired, availableValueAddedServiceGroup.isRequired) && Objects.equals(this.valueAddedServices, availableValueAddedServiceGroup.valueAddedServices);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.groupDescription, this.isRequired, this.valueAddedServices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableValueAddedServiceGroup {\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    groupDescription: ").append(this.toIndentedString(this.groupDescription)).append("\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("    valueAddedServices: ").append(this.toIndentedString(this.valueAddedServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

