/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.Address;

@Schema(description="Information about the location of the service job.")
public class ServiceLocation {
    @SerializedName(value="serviceLocationType")
    private ServiceLocationTypeEnum serviceLocationType = null;
    @SerializedName(value="address")
    private Address address = null;

    public ServiceLocation serviceLocationType(ServiceLocationTypeEnum serviceLocationType) {
        this.serviceLocationType = serviceLocationType;
        return this;
    }

    @Schema(description="The location of the service job.")
    public ServiceLocationTypeEnum getServiceLocationType() {
        return this.serviceLocationType;
    }

    public void setServiceLocationType(ServiceLocationTypeEnum serviceLocationType) {
        this.serviceLocationType = serviceLocationType;
    }

    public ServiceLocation address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocation serviceLocation = (ServiceLocation)o;
        return Objects.equals((Object)this.serviceLocationType, (Object)serviceLocation.serviceLocationType) && Objects.equals(this.address, serviceLocation.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceLocationType, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLocation {\n");
        sb.append("    serviceLocationType: ").append(this.toIndentedString((Object)this.serviceLocationType)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ServiceLocationTypeEnum {
        IN_HOME("IN_HOME"),
        IN_STORE("IN_STORE"),
        ONLINE("ONLINE");

        private String value;

        private ServiceLocationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ServiceLocationTypeEnum fromValue(String input) {
            for (ServiceLocationTypeEnum b : ServiceLocationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ServiceLocationTypeEnum> {
            public void write(JsonWriter jsonWriter, ServiceLocationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ServiceLocationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ServiceLocationTypeEnum.fromValue(value);
            }
        }
    }
}

