/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.AvailabilityRecord;

@Schema(description="Reservation object reduces the capacity of a resource.")
public class Reservation {
    @SerializedName(value="reservationId")
    private String reservationId = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="availability")
    private AvailabilityRecord availability = null;

    public Reservation reservationId(String reservationId) {
        this.reservationId = reservationId;
        return this;
    }

    @Schema(description="Unique identifier for a reservation. If present, it is treated as an update reservation request and will update the corresponding reservation. Otherwise, it is treated as a new create reservation request.")
    public String getReservationId() {
        return this.reservationId;
    }

    public void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    public Reservation type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Type of reservation.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Reservation availability(AvailabilityRecord availability) {
        this.availability = availability;
        return this;
    }

    @Schema(required=true, description="")
    public AvailabilityRecord getAvailability() {
        return this.availability;
    }

    public void setAvailability(AvailabilityRecord availability) {
        this.availability = availability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reservation reservation = (Reservation)o;
        return Objects.equals(this.reservationId, reservation.reservationId) && Objects.equals((Object)this.type, (Object)reservation.type) && Objects.equals(this.availability, reservation.availability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reservationId, this.type, this.availability});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reservation {\n");
        sb.append("    reservationId: ").append(this.toIndentedString(this.reservationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    availability: ").append(this.toIndentedString(this.availability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        APPOINTMENT("APPOINTMENT"),
        TRAVEL("TRAVEL"),
        VACATION("VACATION"),
        BREAK("BREAK"),
        TRAINING("TRAINING");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

