/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.DayOfWeek;

@Schema(description="Repeated occurrence of an event in a time range.")
public class Recurrence {
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;
    @SerializedName(value="daysOfWeek")
    private List<DayOfWeek> daysOfWeek = null;
    @SerializedName(value="daysOfMonth")
    private List<Integer> daysOfMonth = null;

    public Recurrence endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(required=true, description="End time of the recurrence.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public Recurrence daysOfWeek(List<DayOfWeek> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    public Recurrence addDaysOfWeekItem(DayOfWeek daysOfWeekItem) {
        if (this.daysOfWeek == null) {
            this.daysOfWeek = new ArrayList<DayOfWeek>();
        }
        this.daysOfWeek.add(daysOfWeekItem);
        return this;
    }

    @Schema(description="Days of the week when recurrence is valid. If the schedule is valid every Monday, input will only contain `MONDAY` in the list.")
    public List<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<DayOfWeek> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public Recurrence daysOfMonth(List<Integer> daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
        return this;
    }

    public Recurrence addDaysOfMonthItem(Integer daysOfMonthItem) {
        if (this.daysOfMonth == null) {
            this.daysOfMonth = new ArrayList<Integer>();
        }
        this.daysOfMonth.add(daysOfMonthItem);
        return this;
    }

    @Schema(description="Days of the month when recurrence is valid.")
    public List<Integer> getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setDaysOfMonth(List<Integer> daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurrence recurrence = (Recurrence)o;
        return Objects.equals(this.endTime, recurrence.endTime) && Objects.equals(this.daysOfWeek, recurrence.daysOfWeek) && Objects.equals(this.daysOfMonth, recurrence.daysOfMonth);
    }

    public int hashCode() {
        return Objects.hash(this.endTime, this.daysOfWeek, this.daysOfMonth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurrence {\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    daysOfMonth: ").append(this.toIndentedString(this.daysOfMonth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

