/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.CapacityType;

@Schema(description="Request schema for the `getRangeSlotCapacity` operation. This schema is used to define the time range and capacity types that are being queried.")
public class RangeSlotCapacityQuery {
    @SerializedName(value="capacityTypes")
    private List<CapacityType> capacityTypes = null;
    @SerializedName(value="startDateTime")
    private OffsetDateTime startDateTime = null;
    @SerializedName(value="endDateTime")
    private OffsetDateTime endDateTime = null;

    public RangeSlotCapacityQuery capacityTypes(List<CapacityType> capacityTypes) {
        this.capacityTypes = capacityTypes;
        return this;
    }

    public RangeSlotCapacityQuery addCapacityTypesItem(CapacityType capacityTypesItem) {
        if (this.capacityTypes == null) {
            this.capacityTypes = new ArrayList<CapacityType>();
        }
        this.capacityTypes.add(capacityTypesItem);
        return this;
    }

    @Schema(description="An array of capacity types which are being requested. Default value is `[SCHEDULED_CAPACITY]`.")
    public List<CapacityType> getCapacityTypes() {
        return this.capacityTypes;
    }

    public void setCapacityTypes(List<CapacityType> capacityTypes) {
        this.capacityTypes = capacityTypes;
    }

    public RangeSlotCapacityQuery startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(required=true, description="Start date time from which the capacity slots are being requested in ISO 8601 format.")
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public RangeSlotCapacityQuery endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(required=true, description="End date time up to which the capacity slots are being requested in ISO 8601 format.")
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeSlotCapacityQuery rangeSlotCapacityQuery = (RangeSlotCapacityQuery)o;
        return Objects.equals(this.capacityTypes, rangeSlotCapacityQuery.capacityTypes) && Objects.equals(this.startDateTime, rangeSlotCapacityQuery.startDateTime) && Objects.equals(this.endDateTime, rangeSlotCapacityQuery.endDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.capacityTypes, this.startDateTime, this.endDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RangeSlotCapacityQuery {\n");
        sb.append("    capacityTypes: ").append(this.toIndentedString(this.capacityTypes)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

