/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Capacity slots represented in a format similar to availability rules.")
public class RangeSlot {
    @SerializedName(value="startDateTime")
    private OffsetDateTime startDateTime = null;
    @SerializedName(value="endDateTime")
    private OffsetDateTime endDateTime = null;
    @SerializedName(value="capacity")
    private Integer capacity = null;

    public RangeSlot startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(description="Start date time of slot in ISO 8601 format with precision of seconds.")
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public RangeSlot endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(description="End date time of slot in ISO 8601 format with precision of seconds.")
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public RangeSlot capacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @Schema(description="Capacity of the slot.")
    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeSlot rangeSlot = (RangeSlot)o;
        return Objects.equals(this.startDateTime, rangeSlot.startDateTime) && Objects.equals(this.endDateTime, rangeSlot.endDateTime) && Objects.equals(this.capacity, rangeSlot.capacity);
    }

    public int hashCode() {
        return Objects.hash(this.startDateTime, this.endDateTime, this.capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RangeSlot {\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

