/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.FixedSlot;

@Schema(description="Response schema for the `getFixedSlotCapacity` operation.")
public class FixedSlotCapacity {
    @SerializedName(value="resourceId")
    private String resourceId = null;
    @SerializedName(value="slotDuration")
    private BigDecimal slotDuration = null;
    @SerializedName(value="capacities")
    private List<FixedSlot> capacities = null;
    @SerializedName(value="nextPageToken")
    private String nextPageToken = null;

    public FixedSlotCapacity resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Schema(description="Resource Identifier.")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public FixedSlotCapacity slotDuration(BigDecimal slotDuration) {
        this.slotDuration = slotDuration;
        return this;
    }

    @Schema(description="The duration of each slot which is returned. This value will be a multiple of 5 and fall in the following range: 5 <= `slotDuration` <= 360.")
    public BigDecimal getSlotDuration() {
        return this.slotDuration;
    }

    public void setSlotDuration(BigDecimal slotDuration) {
        this.slotDuration = slotDuration;
    }

    public FixedSlotCapacity capacities(List<FixedSlot> capacities) {
        this.capacities = capacities;
        return this;
    }

    public FixedSlotCapacity addCapacitiesItem(FixedSlot capacitiesItem) {
        if (this.capacities == null) {
            this.capacities = new ArrayList<FixedSlot>();
        }
        this.capacities.add(capacitiesItem);
        return this;
    }

    @Schema(description="Array of capacity slots in fixed slot format.")
    public List<FixedSlot> getCapacities() {
        return this.capacities;
    }

    public void setCapacities(List<FixedSlot> capacities) {
        this.capacities = capacities;
    }

    public FixedSlotCapacity nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Schema(description="Next page token, if there are more pages.")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSlotCapacity fixedSlotCapacity = (FixedSlotCapacity)o;
        return Objects.equals(this.resourceId, fixedSlotCapacity.resourceId) && Objects.equals(this.slotDuration, fixedSlotCapacity.slotDuration) && Objects.equals(this.capacities, fixedSlotCapacity.capacities) && Objects.equals(this.nextPageToken, fixedSlotCapacity.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.slotDuration, this.capacities, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FixedSlotCapacity {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    slotDuration: ").append(this.toIndentedString(this.slotDuration)).append("\n");
        sb.append("    capacities: ").append(this.toIndentedString(this.capacities)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

