/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="In this slot format each slot only has the requested capacity types. This slot size is as specified by slot duration.")
public class FixedSlot {
    @SerializedName(value="startDateTime")
    private OffsetDateTime startDateTime = null;
    @SerializedName(value="scheduledCapacity")
    private Integer scheduledCapacity = null;
    @SerializedName(value="availableCapacity")
    private Integer availableCapacity = null;
    @SerializedName(value="encumberedCapacity")
    private Integer encumberedCapacity = null;
    @SerializedName(value="reservedCapacity")
    private Integer reservedCapacity = null;

    public FixedSlot startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(description="Start date time of slot in ISO 8601 format with precision of seconds.")
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public FixedSlot scheduledCapacity(Integer scheduledCapacity) {
        this.scheduledCapacity = scheduledCapacity;
        return this;
    }

    @Schema(description="Scheduled capacity corresponding to the slot. This capacity represents the originally allocated capacity as per resource schedule.")
    public Integer getScheduledCapacity() {
        return this.scheduledCapacity;
    }

    public void setScheduledCapacity(Integer scheduledCapacity) {
        this.scheduledCapacity = scheduledCapacity;
    }

    public FixedSlot availableCapacity(Integer availableCapacity) {
        this.availableCapacity = availableCapacity;
        return this;
    }

    @Schema(description="Available capacity corresponding to the slot. This capacity represents the capacity available for allocation to reservations.")
    public Integer getAvailableCapacity() {
        return this.availableCapacity;
    }

    public void setAvailableCapacity(Integer availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public FixedSlot encumberedCapacity(Integer encumberedCapacity) {
        this.encumberedCapacity = encumberedCapacity;
        return this;
    }

    @Schema(description="Encumbered capacity corresponding to the slot. This capacity represents the capacity allocated for Amazon Jobs/Appointments/Orders.")
    public Integer getEncumberedCapacity() {
        return this.encumberedCapacity;
    }

    public void setEncumberedCapacity(Integer encumberedCapacity) {
        this.encumberedCapacity = encumberedCapacity;
    }

    public FixedSlot reservedCapacity(Integer reservedCapacity) {
        this.reservedCapacity = reservedCapacity;
        return this;
    }

    @Schema(description="Reserved capacity corresponding to the slot. This capacity represents the capacity made unavailable due to events like Breaks/Leaves/Lunch.")
    public Integer getReservedCapacity() {
        return this.reservedCapacity;
    }

    public void setReservedCapacity(Integer reservedCapacity) {
        this.reservedCapacity = reservedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSlot fixedSlot = (FixedSlot)o;
        return Objects.equals(this.startDateTime, fixedSlot.startDateTime) && Objects.equals(this.scheduledCapacity, fixedSlot.scheduledCapacity) && Objects.equals(this.availableCapacity, fixedSlot.availableCapacity) && Objects.equals(this.encumberedCapacity, fixedSlot.encumberedCapacity) && Objects.equals(this.reservedCapacity, fixedSlot.reservedCapacity);
    }

    public int hashCode() {
        return Objects.hash(this.startDateTime, this.scheduledCapacity, this.availableCapacity, this.encumberedCapacity, this.reservedCapacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FixedSlot {\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    scheduledCapacity: ").append(this.toIndentedString(this.scheduledCapacity)).append("\n");
        sb.append("    availableCapacity: ").append(this.toIndentedString(this.availableCapacity)).append("\n");
        sb.append("    encumberedCapacity: ").append(this.toIndentedString(this.encumberedCapacity)).append("\n");
        sb.append("    reservedCapacity: ").append(this.toIndentedString(this.reservedCapacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

