/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about the buyer.")
public class Buyer {
    @SerializedName(value="buyerId")
    private String buyerId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="phone")
    private String phone = null;
    @SerializedName(value="isPrimeMember")
    private Boolean isPrimeMember = null;

    public Buyer buyerId(String buyerId) {
        this.buyerId = buyerId;
        return this;
    }

    @Schema(description="The identifier of the buyer.")
    public String getBuyerId() {
        return this.buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public Buyer name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the buyer.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Buyer phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="The phone number of the buyer.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Buyer isPrimeMember(Boolean isPrimeMember) {
        this.isPrimeMember = isPrimeMember;
        return this;
    }

    @Schema(description="When true, the service is for an Amazon Prime buyer.")
    public Boolean isIsPrimeMember() {
        return this.isPrimeMember;
    }

    public void setIsPrimeMember(Boolean isPrimeMember) {
        this.isPrimeMember = isPrimeMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Buyer buyer = (Buyer)o;
        return Objects.equals(this.buyerId, buyer.buyerId) && Objects.equals(this.name, buyer.name) && Objects.equals(this.phone, buyer.phone) && Objects.equals(this.isPrimeMember, buyer.isPrimeMember);
    }

    public int hashCode() {
        return Objects.hash(this.buyerId, this.name, this.phone, this.isPrimeMember);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Buyer {\n");
        sb.append("    buyerId: ").append(this.toIndentedString(this.buyerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    isPrimeMember: ").append(this.toIndentedString(this.isPrimeMember)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

