/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.AppointmentSlot;

@Schema(description="Availability information as per the service context queried.")
public class AppointmentSlotReport {
    @SerializedName(value="schedulingType")
    private SchedulingTypeEnum schedulingType = null;
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;
    @SerializedName(value="appointmentSlots")
    private List<AppointmentSlot> appointmentSlots = null;

    public AppointmentSlotReport schedulingType(SchedulingTypeEnum schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @Schema(description="Defines the type of slots.")
    public SchedulingTypeEnum getSchedulingType() {
        return this.schedulingType;
    }

    public void setSchedulingType(SchedulingTypeEnum schedulingType) {
        this.schedulingType = schedulingType;
    }

    public AppointmentSlotReport startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="Start Time from which the appointment slots are generated in ISO 8601 format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public AppointmentSlotReport endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(description="End Time up to which the appointment slots are generated in ISO 8601 format.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public AppointmentSlotReport appointmentSlots(List<AppointmentSlot> appointmentSlots) {
        this.appointmentSlots = appointmentSlots;
        return this;
    }

    public AppointmentSlotReport addAppointmentSlotsItem(AppointmentSlot appointmentSlotsItem) {
        if (this.appointmentSlots == null) {
            this.appointmentSlots = new ArrayList<AppointmentSlot>();
        }
        this.appointmentSlots.add(appointmentSlotsItem);
        return this;
    }

    @Schema(description="A list of time windows along with associated capacity in which the service can be performed.")
    public List<AppointmentSlot> getAppointmentSlots() {
        return this.appointmentSlots;
    }

    public void setAppointmentSlots(List<AppointmentSlot> appointmentSlots) {
        this.appointmentSlots = appointmentSlots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppointmentSlotReport appointmentSlotReport = (AppointmentSlotReport)o;
        return Objects.equals((Object)this.schedulingType, (Object)appointmentSlotReport.schedulingType) && Objects.equals(this.startTime, appointmentSlotReport.startTime) && Objects.equals(this.endTime, appointmentSlotReport.endTime) && Objects.equals(this.appointmentSlots, appointmentSlotReport.appointmentSlots);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schedulingType, this.startTime, this.endTime, this.appointmentSlots});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppointmentSlotReport {\n");
        sb.append("    schedulingType: ").append(this.toIndentedString((Object)this.schedulingType)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    appointmentSlots: ").append(this.toIndentedString(this.appointmentSlots)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SchedulingTypeEnum {
        REAL_TIME_SCHEDULING("REAL_TIME_SCHEDULING"),
        NON_REAL_TIME_SCHEDULING("NON_REAL_TIME_SCHEDULING");

        private String value;

        private SchedulingTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SchedulingTypeEnum fromValue(String input) {
            for (SchedulingTypeEnum b : SchedulingTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SchedulingTypeEnum> {
            public void write(JsonWriter jsonWriter, SchedulingTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SchedulingTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SchedulingTypeEnum.fromValue(value);
            }
        }
    }
}

