/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.ScheduleExpression;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.ScheduleTransferType;

@Schema(description="Parameters containing information required for initiating a schedule transfer ")
public class TransferScheduleInformation {
    @SerializedName(value="scheduleStartDate")
    private OffsetDateTime scheduleStartDate = null;
    @SerializedName(value="scheduleEndDate")
    private OffsetDateTime scheduleEndDate = null;
    @SerializedName(value="scheduleExpression")
    private ScheduleExpression scheduleExpression = null;
    @SerializedName(value="scheduleType")
    private ScheduleTransferType scheduleType = null;

    public TransferScheduleInformation scheduleStartDate(OffsetDateTime scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
        return this;
    }

    @Schema(example="2024-03-01T00:00Z", description="Field to specify start date of the scheduled transfer ")
    public OffsetDateTime getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public void setScheduleStartDate(OffsetDateTime scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
    }

    public TransferScheduleInformation scheduleEndDate(OffsetDateTime scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
        return this;
    }

    @Schema(example="2027-03-01T00:00Z", description="Field to specify end date of the scheduled transfer ")
    public OffsetDateTime getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public void setScheduleEndDate(OffsetDateTime scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
    }

    public TransferScheduleInformation scheduleExpression(ScheduleExpression scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
        return this;
    }

    @Schema(description="")
    public ScheduleExpression getScheduleExpression() {
        return this.scheduleExpression;
    }

    public void setScheduleExpression(ScheduleExpression scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
    }

    public TransferScheduleInformation scheduleType(ScheduleTransferType scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    @Schema(description="")
    public ScheduleTransferType getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(ScheduleTransferType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferScheduleInformation transferScheduleInformation = (TransferScheduleInformation)o;
        return Objects.equals(this.scheduleStartDate, transferScheduleInformation.scheduleStartDate) && Objects.equals(this.scheduleEndDate, transferScheduleInformation.scheduleEndDate) && Objects.equals(this.scheduleExpression, transferScheduleInformation.scheduleExpression) && Objects.equals((Object)this.scheduleType, (Object)transferScheduleInformation.scheduleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheduleStartDate, this.scheduleEndDate, this.scheduleExpression, this.scheduleType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferScheduleInformation {\n");
        sb.append("    scheduleStartDate: ").append(this.toIndentedString(this.scheduleStartDate)).append("\n");
        sb.append("    scheduleEndDate: ").append(this.toIndentedString(this.scheduleEndDate)).append("\n");
        sb.append("    scheduleExpression: ").append(this.toIndentedString(this.scheduleExpression)).append("\n");
        sb.append("    scheduleType: ").append(this.toIndentedString((Object)this.scheduleType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

