/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.PaymentPreference;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionAccount;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionType;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleFailures;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleInformation;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleStatus;

@Schema(description="Transfer schedule details and related historical details.")
public class TransferSchedule {
    @SerializedName(value="transferScheduleId")
    private String transferScheduleId = null;
    @SerializedName(value="transactionType")
    private TransactionType transactionType = null;
    @SerializedName(value="transactionSourceAccount")
    private TransactionAccount transactionSourceAccount = null;
    @SerializedName(value="transactionDestinationAccount")
    private TransactionAccount transactionDestinationAccount = null;
    @SerializedName(value="transferScheduleStatus")
    private TransferScheduleStatus transferScheduleStatus = null;
    @SerializedName(value="transferScheduleInformation")
    private TransferScheduleInformation transferScheduleInformation = null;
    @SerializedName(value="paymentPreference")
    private PaymentPreference paymentPreference = null;
    @SerializedName(value="transferScheduleFailures")
    private List<TransferScheduleFailures> transferScheduleFailures = new ArrayList<TransferScheduleFailures>();

    public TransferSchedule transferScheduleId(String transferScheduleId) {
        this.transferScheduleId = transferScheduleId;
        return this;
    }

    @Schema(required=true, description="The unique identifier provided by Amazon to the scheduled transfer ")
    public String getTransferScheduleId() {
        return this.transferScheduleId;
    }

    public void setTransferScheduleId(String transferScheduleId) {
        this.transferScheduleId = transferScheduleId;
    }

    public TransferSchedule transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public TransferSchedule transactionSourceAccount(TransactionAccount transactionSourceAccount) {
        this.transactionSourceAccount = transactionSourceAccount;
        return this;
    }

    @Schema(description="")
    public TransactionAccount getTransactionSourceAccount() {
        return this.transactionSourceAccount;
    }

    public void setTransactionSourceAccount(TransactionAccount transactionSourceAccount) {
        this.transactionSourceAccount = transactionSourceAccount;
    }

    public TransferSchedule transactionDestinationAccount(TransactionAccount transactionDestinationAccount) {
        this.transactionDestinationAccount = transactionDestinationAccount;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionAccount getTransactionDestinationAccount() {
        return this.transactionDestinationAccount;
    }

    public void setTransactionDestinationAccount(TransactionAccount transactionDestinationAccount) {
        this.transactionDestinationAccount = transactionDestinationAccount;
    }

    public TransferSchedule transferScheduleStatus(TransferScheduleStatus transferScheduleStatus) {
        this.transferScheduleStatus = transferScheduleStatus;
        return this;
    }

    @Schema(required=true, description="")
    public TransferScheduleStatus getTransferScheduleStatus() {
        return this.transferScheduleStatus;
    }

    public void setTransferScheduleStatus(TransferScheduleStatus transferScheduleStatus) {
        this.transferScheduleStatus = transferScheduleStatus;
    }

    public TransferSchedule transferScheduleInformation(TransferScheduleInformation transferScheduleInformation) {
        this.transferScheduleInformation = transferScheduleInformation;
        return this;
    }

    @Schema(required=true, description="")
    public TransferScheduleInformation getTransferScheduleInformation() {
        return this.transferScheduleInformation;
    }

    public void setTransferScheduleInformation(TransferScheduleInformation transferScheduleInformation) {
        this.transferScheduleInformation = transferScheduleInformation;
    }

    public TransferSchedule paymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
        return this;
    }

    @Schema(description="")
    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference;
    }

    public void setPaymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
    }

    public TransferSchedule transferScheduleFailures(List<TransferScheduleFailures> transferScheduleFailures) {
        this.transferScheduleFailures = transferScheduleFailures;
        return this;
    }

    public TransferSchedule addTransferScheduleFailuresItem(TransferScheduleFailures transferScheduleFailuresItem) {
        this.transferScheduleFailures.add(transferScheduleFailuresItem);
        return this;
    }

    @Schema(required=true, description="Collection that holds Transfer Schedules that has been cancelled or failed due to certain reasons. ")
    public List<TransferScheduleFailures> getTransferScheduleFailures() {
        return this.transferScheduleFailures;
    }

    public void setTransferScheduleFailures(List<TransferScheduleFailures> transferScheduleFailures) {
        this.transferScheduleFailures = transferScheduleFailures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferSchedule transferSchedule = (TransferSchedule)o;
        return Objects.equals(this.transferScheduleId, transferSchedule.transferScheduleId) && Objects.equals((Object)this.transactionType, (Object)transferSchedule.transactionType) && Objects.equals(this.transactionSourceAccount, transferSchedule.transactionSourceAccount) && Objects.equals(this.transactionDestinationAccount, transferSchedule.transactionDestinationAccount) && Objects.equals((Object)this.transferScheduleStatus, (Object)transferSchedule.transferScheduleStatus) && Objects.equals(this.transferScheduleInformation, transferSchedule.transferScheduleInformation) && Objects.equals(this.paymentPreference, transferSchedule.paymentPreference) && Objects.equals(this.transferScheduleFailures, transferSchedule.transferScheduleFailures);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferScheduleId, this.transactionType, this.transactionSourceAccount, this.transactionDestinationAccount, this.transferScheduleStatus, this.transferScheduleInformation, this.paymentPreference, this.transferScheduleFailures});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferSchedule {\n");
        sb.append("    transferScheduleId: ").append(this.toIndentedString(this.transferScheduleId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    transactionSourceAccount: ").append(this.toIndentedString(this.transactionSourceAccount)).append("\n");
        sb.append("    transactionDestinationAccount: ").append(this.toIndentedString(this.transactionDestinationAccount)).append("\n");
        sb.append("    transferScheduleStatus: ").append(this.toIndentedString((Object)this.transferScheduleStatus)).append("\n");
        sb.append("    transferScheduleInformation: ").append(this.toIndentedString(this.transferScheduleInformation)).append("\n");
        sb.append("    paymentPreference: ").append(this.toIndentedString(this.paymentPreference)).append("\n");
        sb.append("    transferScheduleFailures: ").append(this.toIndentedString(this.transferScheduleFailures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

