/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellers.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellers.v1.Address;

@Schema(description="Information about the seller's primary contact.")
public class PrimaryContact {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="nonLatinName")
    private String nonLatinName = null;

    public PrimaryContact name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The full name of the seller's primary contact.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrimaryContact address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(required=true, description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public PrimaryContact nonLatinName(String nonLatinName) {
        this.nonLatinName = nonLatinName;
        return this;
    }

    @Schema(description="The non-Latin script version of the primary contact's name, if applicable.")
    public String getNonLatinName() {
        return this.nonLatinName;
    }

    public void setNonLatinName(String nonLatinName) {
        this.nonLatinName = nonLatinName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryContact primaryContact = (PrimaryContact)o;
        return Objects.equals(this.name, primaryContact.name) && Objects.equals(this.address, primaryContact.address) && Objects.equals(this.nonLatinName, primaryContact.nonLatinName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.nonLatinName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrimaryContact {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    nonLatinName: ").append(this.toIndentedString(this.nonLatinName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

