/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellers.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.sellers.v1.Business;
import software.amazon.spapi.models.sellers.v1.MarketplaceParticipationList;
import software.amazon.spapi.models.sellers.v1.PrimaryContact;

@Schema(description="The response schema for the `getAccount` operation.")
public class Account {
    @SerializedName(value="marketplaceParticipationList")
    private MarketplaceParticipationList marketplaceParticipationList = null;
    @SerializedName(value="businessType")
    private BusinessTypeEnum businessType = null;
    @SerializedName(value="sellingPlan")
    private SellingPlanEnum sellingPlan = null;
    @SerializedName(value="business")
    private Business business = null;
    @SerializedName(value="primaryContact")
    private PrimaryContact primaryContact = null;

    public Account marketplaceParticipationList(MarketplaceParticipationList marketplaceParticipationList) {
        this.marketplaceParticipationList = marketplaceParticipationList;
        return this;
    }

    @Schema(required=true, description="")
    public MarketplaceParticipationList getMarketplaceParticipationList() {
        return this.marketplaceParticipationList;
    }

    public void setMarketplaceParticipationList(MarketplaceParticipationList marketplaceParticipationList) {
        this.marketplaceParticipationList = marketplaceParticipationList;
    }

    public Account businessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    @Schema(required=true, description="The type of business registered for the seller account.")
    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public Account sellingPlan(SellingPlanEnum sellingPlan) {
        this.sellingPlan = sellingPlan;
        return this;
    }

    @Schema(required=true, description="The selling plan details.")
    public SellingPlanEnum getSellingPlan() {
        return this.sellingPlan;
    }

    public void setSellingPlan(SellingPlanEnum sellingPlan) {
        this.sellingPlan = sellingPlan;
    }

    public Account business(Business business) {
        this.business = business;
        return this;
    }

    @Schema(description="")
    public Business getBusiness() {
        return this.business;
    }

    public void setBusiness(Business business) {
        this.business = business;
    }

    public Account primaryContact(PrimaryContact primaryContact) {
        this.primaryContact = primaryContact;
        return this;
    }

    @Schema(description="")
    public PrimaryContact getPrimaryContact() {
        return this.primaryContact;
    }

    public void setPrimaryContact(PrimaryContact primaryContact) {
        this.primaryContact = primaryContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.marketplaceParticipationList, account.marketplaceParticipationList) && Objects.equals((Object)this.businessType, (Object)account.businessType) && Objects.equals((Object)this.sellingPlan, (Object)account.sellingPlan) && Objects.equals(this.business, account.business) && Objects.equals(this.primaryContact, account.primaryContact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceParticipationList, this.businessType, this.sellingPlan, this.business, this.primaryContact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    marketplaceParticipationList: ").append(this.toIndentedString(this.marketplaceParticipationList)).append("\n");
        sb.append("    businessType: ").append(this.toIndentedString((Object)this.businessType)).append("\n");
        sb.append("    sellingPlan: ").append(this.toIndentedString((Object)this.sellingPlan)).append("\n");
        sb.append("    business: ").append(this.toIndentedString(this.business)).append("\n");
        sb.append("    primaryContact: ").append(this.toIndentedString(this.primaryContact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SellingPlanEnum {
        PROFESSIONAL("PROFESSIONAL"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private SellingPlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SellingPlanEnum fromValue(String input) {
            for (SellingPlanEnum b : SellingPlanEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SellingPlanEnum> {
            public void write(JsonWriter jsonWriter, SellingPlanEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SellingPlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SellingPlanEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BusinessTypeEnum {
        CHARITY("CHARITY"),
        CRAFTSMAN("CRAFTSMAN"),
        NATURAL_PERSON_COMPANY("NATURAL_PERSON_COMPANY"),
        PUBLIC_LISTED("PUBLIC_LISTED"),
        PRIVATE_LIMITED("PRIVATE_LIMITED"),
        SOLE_PROPRIETORSHIP("SOLE_PROPRIETORSHIP"),
        STATE_OWNED("STATE_OWNED"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private BusinessTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BusinessTypeEnum fromValue(String input) {
            for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BusinessTypeEnum> {
            public void write(JsonWriter jsonWriter, BusinessTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public BusinessTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BusinessTypeEnum.fromValue(value);
            }
        }
    }
}

