/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.reports.v2021_06_30;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.reports.v2021_06_30.ReportOptions;

@Schema(description="Detailed information about a report schedule.")
public class ReportSchedule {
    @SerializedName(value="reportScheduleId")
    private String reportScheduleId = null;
    @SerializedName(value="reportType")
    private String reportType = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = null;
    @SerializedName(value="reportOptions")
    private ReportOptions reportOptions = null;
    @SerializedName(value="period")
    private String period = null;
    @SerializedName(value="nextReportCreationTime")
    private OffsetDateTime nextReportCreationTime = null;

    public ReportSchedule reportScheduleId(String reportScheduleId) {
        this.reportScheduleId = reportScheduleId;
        return this;
    }

    @Schema(required=true, description="The identifier for the report schedule. This identifier is unique only in combination with a seller ID.")
    public String getReportScheduleId() {
        return this.reportScheduleId;
    }

    public void setReportScheduleId(String reportScheduleId) {
        this.reportScheduleId = reportScheduleId;
    }

    public ReportSchedule reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @Schema(required=true, description="The report type. Refer to [Report Type Values](https://developer-docs.amazon.com/sp-api/docs/report-type-values) for more information.")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public ReportSchedule marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public ReportSchedule addMarketplaceIdsItem(String marketplaceIdsItem) {
        if (this.marketplaceIds == null) {
            this.marketplaceIds = new ArrayList<String>();
        }
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(description="A list of marketplace identifiers. The report document's contents will contain data for all of the specified marketplaces, unless the report type indicates otherwise.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public ReportSchedule reportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        return this;
    }

    @Schema(description="")
    public ReportOptions getReportOptions() {
        return this.reportOptions;
    }

    public void setReportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
    }

    public ReportSchedule period(String period) {
        this.period = period;
        return this;
    }

    @Schema(required=true, description="An <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> period value that indicates how often a report should be created.")
    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public ReportSchedule nextReportCreationTime(OffsetDateTime nextReportCreationTime) {
        this.nextReportCreationTime = nextReportCreationTime;
        return this;
    }

    @Schema(description="The date and time when the schedule will create its next report, in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> date time format.")
    public OffsetDateTime getNextReportCreationTime() {
        return this.nextReportCreationTime;
    }

    public void setNextReportCreationTime(OffsetDateTime nextReportCreationTime) {
        this.nextReportCreationTime = nextReportCreationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportSchedule reportSchedule = (ReportSchedule)o;
        return Objects.equals(this.reportScheduleId, reportSchedule.reportScheduleId) && Objects.equals(this.reportType, reportSchedule.reportType) && Objects.equals(this.marketplaceIds, reportSchedule.marketplaceIds) && Objects.equals(this.reportOptions, reportSchedule.reportOptions) && Objects.equals(this.period, reportSchedule.period) && Objects.equals(this.nextReportCreationTime, reportSchedule.nextReportCreationTime);
    }

    public int hashCode() {
        return Objects.hash(this.reportScheduleId, this.reportType, this.marketplaceIds, this.reportOptions, this.period, this.nextReportCreationTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportSchedule {\n");
        sb.append("    reportScheduleId: ").append(this.toIndentedString(this.reportScheduleId)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    reportOptions: ").append(this.toIndentedString(this.reportOptions)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    nextReportCreationTime: ").append(this.toIndentedString(this.nextReportCreationTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

