/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.reports.v2021_06_30;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Information required for the report document.")
public class ReportDocument {
    @SerializedName(value="reportDocumentId")
    private String reportDocumentId = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="compressionAlgorithm")
    private CompressionAlgorithmEnum compressionAlgorithm = null;

    public ReportDocument reportDocumentId(String reportDocumentId) {
        this.reportDocumentId = reportDocumentId;
        return this;
    }

    @Schema(required=true, description="The identifier for the report document. This identifier is unique only in combination with a seller ID.")
    public String getReportDocumentId() {
        return this.reportDocumentId;
    }

    public void setReportDocumentId(String reportDocumentId) {
        this.reportDocumentId = reportDocumentId;
    }

    public ReportDocument url(String url) {
        this.url = url;
        return this;
    }

    @Schema(required=true, description="A presigned URL for the report document. If `compressionAlgorithm` is not returned, you can download the report directly from this URL. This URL expires after 5 minutes.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ReportDocument compressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
        return this;
    }

    @Schema(description="If the report document contents have been compressed, the compression algorithm used is returned in this property and you must decompress the report when you download. Otherwise, you can download the report directly. Refer to [Step 2. Download the report](https://developer-docs.amazon.com/sp-api/docs/reports-api-v2021-06-30-retrieve-a-report#step-2-download-the-report) in the use case guide, where sample code is provided.")
    public CompressionAlgorithmEnum getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithmEnum compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportDocument reportDocument = (ReportDocument)o;
        return Objects.equals(this.reportDocumentId, reportDocument.reportDocumentId) && Objects.equals(this.url, reportDocument.url) && Objects.equals((Object)this.compressionAlgorithm, (Object)reportDocument.compressionAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reportDocumentId, this.url, this.compressionAlgorithm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportDocument {\n");
        sb.append("    reportDocumentId: ").append(this.toIndentedString(this.reportDocumentId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    compressionAlgorithm: ").append(this.toIndentedString((Object)this.compressionAlgorithm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionAlgorithmEnum {
        GZIP("GZIP");

        private String value;

        private CompressionAlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionAlgorithmEnum fromValue(String input) {
            for (CompressionAlgorithmEnum b : CompressionAlgorithmEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionAlgorithmEnum> {
            public void write(JsonWriter jsonWriter, CompressionAlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CompressionAlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionAlgorithmEnum.fromValue(value);
            }
        }
    }
}

