/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.replenishment.v2022_11_07;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.replenishment.v2022_11_07.EligibilityStatus;
import software.amazon.spapi.models.replenishment.v2022_11_07.Preference;
import software.amazon.spapi.models.replenishment.v2022_11_07.ProgramTypes;
import software.amazon.spapi.models.replenishment.v2022_11_07.Promotion;

@Schema(description="Use these parameters to filter results. Any result must match all of the provided parameters. For any parameter that is an array, the result must match at least one element in the provided array.")
public class ListOffersRequestFilters {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="skus")
    private List<String> skus = null;
    @SerializedName(value="asins")
    private List<String> asins = null;
    @SerializedName(value="eligibilities")
    private List<EligibilityStatus> eligibilities = null;
    @SerializedName(value="preferences")
    private Preference preferences = null;
    @SerializedName(value="promotions")
    private Promotion promotions = null;
    @SerializedName(value="programTypes")
    private ProgramTypes programTypes = null;

    public ListOffersRequestFilters marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ListOffersRequestFilters skus(List<String> skus) {
        this.skus = skus;
        return this;
    }

    public ListOffersRequestFilters addSkusItem(String skusItem) {
        if (this.skus == null) {
            this.skus = new ArrayList<String>();
        }
        this.skus.add(skusItem);
        return this;
    }

    @Schema(description="A list of SKUs to filter. This filter is only supported for sellers and not for vendors.")
    public List<String> getSkus() {
        return this.skus;
    }

    public void setSkus(List<String> skus) {
        this.skus = skus;
    }

    public ListOffersRequestFilters asins(List<String> asins) {
        this.asins = asins;
        return this;
    }

    public ListOffersRequestFilters addAsinsItem(String asinsItem) {
        if (this.asins == null) {
            this.asins = new ArrayList<String>();
        }
        this.asins.add(asinsItem);
        return this;
    }

    @Schema(description="A list of Amazon Standard Identification Numbers (ASINs).")
    public List<String> getAsins() {
        return this.asins;
    }

    public void setAsins(List<String> asins) {
        this.asins = asins;
    }

    public ListOffersRequestFilters eligibilities(List<EligibilityStatus> eligibilities) {
        this.eligibilities = eligibilities;
        return this;
    }

    public ListOffersRequestFilters addEligibilitiesItem(EligibilityStatus eligibilitiesItem) {
        if (this.eligibilities == null) {
            this.eligibilities = new ArrayList<EligibilityStatus>();
        }
        this.eligibilities.add(eligibilitiesItem);
        return this;
    }

    @Schema(description="A list of eligibilities associated with an offer.")
    public List<EligibilityStatus> getEligibilities() {
        return this.eligibilities;
    }

    public void setEligibilities(List<EligibilityStatus> eligibilities) {
        this.eligibilities = eligibilities;
    }

    public ListOffersRequestFilters preferences(Preference preferences) {
        this.preferences = preferences;
        return this;
    }

    @Schema(description="")
    public Preference getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preference preferences) {
        this.preferences = preferences;
    }

    public ListOffersRequestFilters promotions(Promotion promotions) {
        this.promotions = promotions;
        return this;
    }

    @Schema(description="")
    public Promotion getPromotions() {
        return this.promotions;
    }

    public void setPromotions(Promotion promotions) {
        this.promotions = promotions;
    }

    public ListOffersRequestFilters programTypes(ProgramTypes programTypes) {
        this.programTypes = programTypes;
        return this;
    }

    @Schema(required=true, description="")
    public ProgramTypes getProgramTypes() {
        return this.programTypes;
    }

    public void setProgramTypes(ProgramTypes programTypes) {
        this.programTypes = programTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOffersRequestFilters listOffersRequestFilters = (ListOffersRequestFilters)o;
        return Objects.equals(this.marketplaceId, listOffersRequestFilters.marketplaceId) && Objects.equals(this.skus, listOffersRequestFilters.skus) && Objects.equals(this.asins, listOffersRequestFilters.asins) && Objects.equals(this.eligibilities, listOffersRequestFilters.eligibilities) && Objects.equals(this.preferences, listOffersRequestFilters.preferences) && Objects.equals(this.promotions, listOffersRequestFilters.promotions) && Objects.equals(this.programTypes, listOffersRequestFilters.programTypes);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.skus, this.asins, this.eligibilities, this.preferences, this.promotions, this.programTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListOffersRequestFilters {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    skus: ").append(this.toIndentedString(this.skus)).append("\n");
        sb.append("    asins: ").append(this.toIndentedString(this.asins)).append("\n");
        sb.append("    eligibilities: ").append(this.toIndentedString(this.eligibilities)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("    promotions: ").append(this.toIndentedString(this.promotions)).append("\n");
        sb.append("    programTypes: ").append(this.toIndentedString(this.programTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

