/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.productfees.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.productfees.v0.OptionalFulfillmentProgram;
import software.amazon.spapi.models.productfees.v0.PriceToEstimateFees;

@Schema(description="A product, marketplace, and proposed price used to request estimated fees.")
public class FeesEstimateRequest {
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="IsAmazonFulfilled")
    private Boolean isAmazonFulfilled = null;
    @SerializedName(value="PriceToEstimateFees")
    private PriceToEstimateFees priceToEstimateFees = null;
    @SerializedName(value="Identifier")
    private String identifier = null;
    @SerializedName(value="OptionalFulfillmentProgram")
    private OptionalFulfillmentProgram optionalFulfillmentProgram = null;

    public FeesEstimateRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="A marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FeesEstimateRequest isAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
        return this;
    }

    @Schema(description="When true, the offer is fulfilled by Amazon.")
    public Boolean isIsAmazonFulfilled() {
        return this.isAmazonFulfilled;
    }

    public void setIsAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
    }

    public FeesEstimateRequest priceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
        return this;
    }

    @Schema(required=true, description="")
    public PriceToEstimateFees getPriceToEstimateFees() {
        return this.priceToEstimateFees;
    }

    public void setPriceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
    }

    public FeesEstimateRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Schema(required=true, description="A unique identifier provided by the caller to track this request.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public FeesEstimateRequest optionalFulfillmentProgram(OptionalFulfillmentProgram optionalFulfillmentProgram) {
        this.optionalFulfillmentProgram = optionalFulfillmentProgram;
        return this;
    }

    @Schema(description="")
    public OptionalFulfillmentProgram getOptionalFulfillmentProgram() {
        return this.optionalFulfillmentProgram;
    }

    public void setOptionalFulfillmentProgram(OptionalFulfillmentProgram optionalFulfillmentProgram) {
        this.optionalFulfillmentProgram = optionalFulfillmentProgram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeesEstimateRequest feesEstimateRequest = (FeesEstimateRequest)o;
        return Objects.equals(this.marketplaceId, feesEstimateRequest.marketplaceId) && Objects.equals(this.isAmazonFulfilled, feesEstimateRequest.isAmazonFulfilled) && Objects.equals(this.priceToEstimateFees, feesEstimateRequest.priceToEstimateFees) && Objects.equals(this.identifier, feesEstimateRequest.identifier) && Objects.equals((Object)this.optionalFulfillmentProgram, (Object)feesEstimateRequest.optionalFulfillmentProgram);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.isAmazonFulfilled, this.priceToEstimateFees, this.identifier, this.optionalFulfillmentProgram});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeesEstimateRequest {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    isAmazonFulfilled: ").append(this.toIndentedString(this.isAmazonFulfilled)).append("\n");
        sb.append("    priceToEstimateFees: ").append(this.toIndentedString(this.priceToEstimateFees)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    optionalFulfillmentProgram: ").append(this.toIndentedString((Object)this.optionalFulfillmentProgram)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

