/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.productfees.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.productfees.v0.IdType;
import software.amazon.spapi.models.productfees.v0.OptionalFulfillmentProgram;
import software.amazon.spapi.models.productfees.v0.PriceToEstimateFees;

@Schema(description="An item identifier, marketplace, time of request, and other details that identify an estimate.")
public class FeesEstimateIdentifier {
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="IdType")
    private IdType idType = null;
    @SerializedName(value="IdValue")
    private String idValue = null;
    @SerializedName(value="IsAmazonFulfilled")
    private Boolean isAmazonFulfilled = null;
    @SerializedName(value="PriceToEstimateFees")
    private PriceToEstimateFees priceToEstimateFees = null;
    @SerializedName(value="SellerInputIdentifier")
    private String sellerInputIdentifier = null;
    @SerializedName(value="OptionalFulfillmentProgram")
    private OptionalFulfillmentProgram optionalFulfillmentProgram = null;

    public FeesEstimateIdentifier marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="A marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FeesEstimateIdentifier sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The seller identifier.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public FeesEstimateIdentifier idType(IdType idType) {
        this.idType = idType;
        return this;
    }

    @Schema(description="")
    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public FeesEstimateIdentifier idValue(String idValue) {
        this.idValue = idValue;
        return this;
    }

    @Schema(description="The item identifier.")
    public String getIdValue() {
        return this.idValue;
    }

    public void setIdValue(String idValue) {
        this.idValue = idValue;
    }

    public FeesEstimateIdentifier isAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
        return this;
    }

    @Schema(description="When true, the offer is fulfilled by Amazon.")
    public Boolean isIsAmazonFulfilled() {
        return this.isAmazonFulfilled;
    }

    public void setIsAmazonFulfilled(Boolean isAmazonFulfilled) {
        this.isAmazonFulfilled = isAmazonFulfilled;
    }

    public FeesEstimateIdentifier priceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
        return this;
    }

    @Schema(description="")
    public PriceToEstimateFees getPriceToEstimateFees() {
        return this.priceToEstimateFees;
    }

    public void setPriceToEstimateFees(PriceToEstimateFees priceToEstimateFees) {
        this.priceToEstimateFees = priceToEstimateFees;
    }

    public FeesEstimateIdentifier sellerInputIdentifier(String sellerInputIdentifier) {
        this.sellerInputIdentifier = sellerInputIdentifier;
        return this;
    }

    @Schema(description="A unique identifier provided by the caller to track this request.")
    public String getSellerInputIdentifier() {
        return this.sellerInputIdentifier;
    }

    public void setSellerInputIdentifier(String sellerInputIdentifier) {
        this.sellerInputIdentifier = sellerInputIdentifier;
    }

    public FeesEstimateIdentifier optionalFulfillmentProgram(OptionalFulfillmentProgram optionalFulfillmentProgram) {
        this.optionalFulfillmentProgram = optionalFulfillmentProgram;
        return this;
    }

    @Schema(description="")
    public OptionalFulfillmentProgram getOptionalFulfillmentProgram() {
        return this.optionalFulfillmentProgram;
    }

    public void setOptionalFulfillmentProgram(OptionalFulfillmentProgram optionalFulfillmentProgram) {
        this.optionalFulfillmentProgram = optionalFulfillmentProgram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeesEstimateIdentifier feesEstimateIdentifier = (FeesEstimateIdentifier)o;
        return Objects.equals(this.marketplaceId, feesEstimateIdentifier.marketplaceId) && Objects.equals(this.sellerId, feesEstimateIdentifier.sellerId) && Objects.equals((Object)this.idType, (Object)feesEstimateIdentifier.idType) && Objects.equals(this.idValue, feesEstimateIdentifier.idValue) && Objects.equals(this.isAmazonFulfilled, feesEstimateIdentifier.isAmazonFulfilled) && Objects.equals(this.priceToEstimateFees, feesEstimateIdentifier.priceToEstimateFees) && Objects.equals(this.sellerInputIdentifier, feesEstimateIdentifier.sellerInputIdentifier) && Objects.equals((Object)this.optionalFulfillmentProgram, (Object)feesEstimateIdentifier.optionalFulfillmentProgram);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.sellerId, this.idType, this.idValue, this.isAmazonFulfilled, this.priceToEstimateFees, this.sellerInputIdentifier, this.optionalFulfillmentProgram});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeesEstimateIdentifier {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    idType: ").append(this.toIndentedString((Object)this.idType)).append("\n");
        sb.append("    idValue: ").append(this.toIndentedString(this.idValue)).append("\n");
        sb.append("    isAmazonFulfilled: ").append(this.toIndentedString(this.isAmazonFulfilled)).append("\n");
        sb.append("    priceToEstimateFees: ").append(this.toIndentedString(this.priceToEstimateFees)).append("\n");
        sb.append("    sellerInputIdentifier: ").append(this.toIndentedString(this.sellerInputIdentifier)).append("\n");
        sb.append("    optionalFulfillmentProgram: ").append(this.toIndentedString((Object)this.optionalFulfillmentProgram)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

