/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.Condition;
import software.amazon.spapi.models.pricing.v2022_05_01.FulfillmentType;
import software.amazon.spapi.models.pricing.v2022_05_01.MoneyType;
import software.amazon.spapi.models.pricing.v2022_05_01.Points;
import software.amazon.spapi.models.pricing.v2022_05_01.PrimeDetails;
import software.amazon.spapi.models.pricing.v2022_05_01.ShippingOption;

@Schema(description="The offer data of a product.")
public class Offer {
    @SerializedName(value="sellerId")
    private String sellerId = null;
    @SerializedName(value="condition")
    private Condition condition = null;
    @SerializedName(value="subCondition")
    private SubConditionEnum subCondition = null;
    @SerializedName(value="fulfillmentType")
    private FulfillmentType fulfillmentType = null;
    @SerializedName(value="listingPrice")
    private MoneyType listingPrice = null;
    @SerializedName(value="shippingOptions")
    private List<ShippingOption> shippingOptions = null;
    @SerializedName(value="points")
    private Points points = null;
    @SerializedName(value="primeDetails")
    private PrimeDetails primeDetails = null;

    public Offer sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(required=true, description="The seller identifier for the offer.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public Offer condition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Schema(required=true, description="")
    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Offer subCondition(SubConditionEnum subCondition) {
        this.subCondition = subCondition;
        return this;
    }

    @Schema(description="The item subcondition of the offer.")
    public SubConditionEnum getSubCondition() {
        return this.subCondition;
    }

    public void setSubCondition(SubConditionEnum subCondition) {
        this.subCondition = subCondition;
    }

    public Offer fulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
        return this;
    }

    @Schema(required=true, description="")
    public FulfillmentType getFulfillmentType() {
        return this.fulfillmentType;
    }

    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
    }

    public Offer listingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getListingPrice() {
        return this.listingPrice;
    }

    public void setListingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
    }

    public Offer shippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
        return this;
    }

    public Offer addShippingOptionsItem(ShippingOption shippingOptionsItem) {
        if (this.shippingOptions == null) {
            this.shippingOptions = new ArrayList<ShippingOption>();
        }
        this.shippingOptions.add(shippingOptionsItem);
        return this;
    }

    @Schema(description="A list of shipping options associated with this offer")
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    public Offer points(Points points) {
        this.points = points;
        return this;
    }

    @Schema(description="")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public Offer primeDetails(PrimeDetails primeDetails) {
        this.primeDetails = primeDetails;
        return this;
    }

    @Schema(description="")
    public PrimeDetails getPrimeDetails() {
        return this.primeDetails;
    }

    public void setPrimeDetails(PrimeDetails primeDetails) {
        this.primeDetails = primeDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offer offer = (Offer)o;
        return Objects.equals(this.sellerId, offer.sellerId) && Objects.equals((Object)this.condition, (Object)offer.condition) && Objects.equals((Object)this.subCondition, (Object)offer.subCondition) && Objects.equals((Object)this.fulfillmentType, (Object)offer.fulfillmentType) && Objects.equals(this.listingPrice, offer.listingPrice) && Objects.equals(this.shippingOptions, offer.shippingOptions) && Objects.equals(this.points, offer.points) && Objects.equals(this.primeDetails, offer.primeDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerId, this.condition, this.subCondition, this.fulfillmentType, this.listingPrice, this.shippingOptions, this.points, this.primeDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Offer {\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString((Object)this.condition)).append("\n");
        sb.append("    subCondition: ").append(this.toIndentedString((Object)this.subCondition)).append("\n");
        sb.append("    fulfillmentType: ").append(this.toIndentedString((Object)this.fulfillmentType)).append("\n");
        sb.append("    listingPrice: ").append(this.toIndentedString(this.listingPrice)).append("\n");
        sb.append("    shippingOptions: ").append(this.toIndentedString(this.shippingOptions)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    primeDetails: ").append(this.toIndentedString(this.primeDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubConditionEnum {
        NEW("New"),
        MINT("Mint"),
        VERYGOOD("VeryGood"),
        GOOD("Good"),
        ACCEPTABLE("Acceptable"),
        POOR("Poor"),
        CLUB("Club"),
        OEM("OEM"),
        WARRANTY("Warranty"),
        REFURBISHEDWARRANTY("RefurbishedWarranty"),
        REFURBISHED("Refurbished"),
        OPENBOX("OpenBox"),
        OTHER("Other");

        private String value;

        private SubConditionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubConditionEnum fromValue(String input) {
            for (SubConditionEnum b : SubConditionEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SubConditionEnum> {
            public void write(JsonWriter jsonWriter, SubConditionEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SubConditionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubConditionEnum.fromValue(value);
            }
        }
    }
}

