/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.HttpBody;
import software.amazon.spapi.models.pricing.v2022_05_01.HttpHeaders;
import software.amazon.spapi.models.pricing.v2022_05_01.HttpMethod;

@Schema(description="The common properties for individual requests within a batch.")
public class BatchRequest {
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="method")
    private HttpMethod method = null;
    @SerializedName(value="body")
    private HttpBody body = null;
    @SerializedName(value="headers")
    private HttpHeaders headers = null;

    public BatchRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(required=true, description="The URI associated with an individual request within a batch. For `FeaturedOfferExpectedPrice`, this is `/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice`.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public BatchRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Schema(required=true, description="")
    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public BatchRequest body(HttpBody body) {
        this.body = body;
        return this;
    }

    @Schema(description="")
    public HttpBody getBody() {
        return this.body;
    }

    public void setBody(HttpBody body) {
        this.body = body;
    }

    public BatchRequest headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Schema(description="")
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)o;
        return Objects.equals(this.uri, batchRequest.uri) && Objects.equals((Object)this.method, (Object)batchRequest.method) && Objects.equals(this.body, batchRequest.body) && Objects.equals(this.headers, batchRequest.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.method, this.body, this.headers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRequest {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

