/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Sales rank information for the item, by category")
public class SalesRankType {
    @SerializedName(value="ProductCategoryId")
    private String productCategoryId = null;
    @SerializedName(value="Rank")
    private Integer rank = null;

    public SalesRankType productCategoryId(String productCategoryId) {
        this.productCategoryId = productCategoryId;
        return this;
    }

    @Schema(required=true, description=" Identifies the item category from which the sales rank is taken.")
    public String getProductCategoryId() {
        return this.productCategoryId;
    }

    public void setProductCategoryId(String productCategoryId) {
        this.productCategoryId = productCategoryId;
    }

    public SalesRankType rank(Integer rank) {
        this.rank = rank;
        return this;
    }

    @Schema(required=true, description="The sales rank of the item within the item category.")
    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesRankType salesRankType = (SalesRankType)o;
        return Objects.equals(this.productCategoryId, salesRankType.productCategoryId) && Objects.equals(this.rank, salesRankType.rank);
    }

    public int hashCode() {
        return Objects.hash(this.productCategoryId, this.rank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesRankType {\n");
        sb.append("    productCategoryId: ").append(this.toIndentedString(this.productCategoryId)).append("\n");
        sb.append("    rank: ").append(this.toIndentedString(this.rank)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

