/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Currency type and monetary value. Schema for demonstrating pricing info.")
public class MoneyType {
    @SerializedName(value="CurrencyCode")
    private String currencyCode = null;
    @SerializedName(value="Amount")
    private BigDecimal amount = null;

    public MoneyType currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="The currency code in ISO 4217 format.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public MoneyType amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="The monetary value.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoneyType moneyType = (MoneyType)o;
        return Objects.equals(this.currencyCode, moneyType.currencyCode) && Objects.equals(this.amount, moneyType.amount);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MoneyType {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

