/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Objects;

@Schema(description="A mapping of additional HTTP headers to send/receive for the individual batch request.")
public class HttpResponseHeaders
extends HashMap<String, String> {
    @SerializedName(value="Date")
    private String date = null;
    @SerializedName(value="x-amzn-RequestId")
    private String xAmznRequestId = null;

    public HttpResponseHeaders date(String date) {
        this.date = date;
        return this;
    }

    @Schema(description="The timestamp that the API request was received.  For more information, consult [RFC 2616 Section 14](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public HttpResponseHeaders xAmznRequestId(String xAmznRequestId) {
        this.xAmznRequestId = xAmznRequestId;
        return this;
    }

    @Schema(description="Unique request reference identifier.")
    public String getXAmznRequestId() {
        return this.xAmznRequestId;
    }

    public void setXAmznRequestId(String xAmznRequestId) {
        this.xAmznRequestId = xAmznRequestId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponseHeaders httpResponseHeaders = (HttpResponseHeaders)o;
        return Objects.equals(this.date, httpResponseHeaders.date) && Objects.equals(this.xAmznRequestId, httpResponseHeaders.xAmznRequestId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.date, this.xAmznRequestId, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpResponseHeaders {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    xAmznRequestId: ").append(this.toIndentedString(this.xAmznRequestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

