/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.OfferCustomerType;
import software.amazon.spapi.models.pricing.v0.PriceType;
import software.amazon.spapi.models.pricing.v0.QuantityDiscountType;

@Schema(description="Schema for competitive pricing information")
public class CompetitivePriceType {
    @SerializedName(value="CompetitivePriceId")
    private String competitivePriceId = null;
    @SerializedName(value="Price")
    private PriceType price = null;
    @SerializedName(value="condition")
    private String condition = null;
    @SerializedName(value="subcondition")
    private String subcondition = null;
    @SerializedName(value="offerType")
    private OfferCustomerType offerType = null;
    @SerializedName(value="quantityTier")
    private Integer quantityTier = null;
    @SerializedName(value="quantityDiscountType")
    private QuantityDiscountType quantityDiscountType = null;
    @SerializedName(value="sellerId")
    private String sellerId = null;
    @SerializedName(value="belongsToRequester")
    private Boolean belongsToRequester = null;

    public CompetitivePriceType competitivePriceId(String competitivePriceId) {
        this.competitivePriceId = competitivePriceId;
        return this;
    }

    @Schema(required=true, description="The pricing model for each price that is returned.  Possible values:  * 1 - New Buy Box Price. * 2 - Used Buy Box Price.")
    public String getCompetitivePriceId() {
        return this.competitivePriceId;
    }

    public void setCompetitivePriceId(String competitivePriceId) {
        this.competitivePriceId = competitivePriceId;
    }

    public CompetitivePriceType price(PriceType price) {
        this.price = price;
        return this;
    }

    @Schema(required=true, description="")
    public PriceType getPrice() {
        return this.price;
    }

    public void setPrice(PriceType price) {
        this.price = price;
    }

    public CompetitivePriceType condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Schema(description="Indicates the condition of the item whose pricing information is returned. Possible values are: New, Used, Collectible, Refurbished, or Club.")
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public CompetitivePriceType subcondition(String subcondition) {
        this.subcondition = subcondition;
        return this;
    }

    @Schema(description="Indicates the subcondition of the item whose pricing information is returned. Possible values are: New, Mint, Very Good, Good, Acceptable, Poor, Club, OEM, Warranty, Refurbished Warranty, Refurbished, Open Box, or Other.")
    public String getSubcondition() {
        return this.subcondition;
    }

    public void setSubcondition(String subcondition) {
        this.subcondition = subcondition;
    }

    public CompetitivePriceType offerType(OfferCustomerType offerType) {
        this.offerType = offerType;
        return this;
    }

    @Schema(description="")
    public OfferCustomerType getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferCustomerType offerType) {
        this.offerType = offerType;
    }

    public CompetitivePriceType quantityTier(Integer quantityTier) {
        this.quantityTier = quantityTier;
        return this;
    }

    @Schema(description="Indicates at what quantity this price becomes active.")
    public Integer getQuantityTier() {
        return this.quantityTier;
    }

    public void setQuantityTier(Integer quantityTier) {
        this.quantityTier = quantityTier;
    }

    public CompetitivePriceType quantityDiscountType(QuantityDiscountType quantityDiscountType) {
        this.quantityDiscountType = quantityDiscountType;
        return this;
    }

    @Schema(description="")
    public QuantityDiscountType getQuantityDiscountType() {
        return this.quantityDiscountType;
    }

    public void setQuantityDiscountType(QuantityDiscountType quantityDiscountType) {
        this.quantityDiscountType = quantityDiscountType;
    }

    public CompetitivePriceType sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The seller identifier for the offer.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public CompetitivePriceType belongsToRequester(Boolean belongsToRequester) {
        this.belongsToRequester = belongsToRequester;
        return this;
    }

    @Schema(description=" Indicates whether or not the pricing information is for an offer listing that belongs to the requester. The requester is the seller associated with the SellerId that was submitted with the request. Possible values are: true and false.")
    public Boolean isBelongsToRequester() {
        return this.belongsToRequester;
    }

    public void setBelongsToRequester(Boolean belongsToRequester) {
        this.belongsToRequester = belongsToRequester;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompetitivePriceType competitivePriceType = (CompetitivePriceType)o;
        return Objects.equals(this.competitivePriceId, competitivePriceType.competitivePriceId) && Objects.equals(this.price, competitivePriceType.price) && Objects.equals(this.condition, competitivePriceType.condition) && Objects.equals(this.subcondition, competitivePriceType.subcondition) && Objects.equals((Object)this.offerType, (Object)competitivePriceType.offerType) && Objects.equals(this.quantityTier, competitivePriceType.quantityTier) && Objects.equals((Object)this.quantityDiscountType, (Object)competitivePriceType.quantityDiscountType) && Objects.equals(this.sellerId, competitivePriceType.sellerId) && Objects.equals(this.belongsToRequester, competitivePriceType.belongsToRequester);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.competitivePriceId, this.price, this.condition, this.subcondition, this.offerType, this.quantityTier, this.quantityDiscountType, this.sellerId, this.belongsToRequester});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompetitivePriceType {\n");
        sb.append("    competitivePriceId: ").append(this.toIndentedString(this.competitivePriceId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    subcondition: ").append(this.toIndentedString(this.subcondition)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    quantityTier: ").append(this.toIndentedString(this.quantityTier)).append("\n");
        sb.append("    quantityDiscountType: ").append(this.toIndentedString((Object)this.quantityDiscountType)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    belongsToRequester: ").append(this.toIndentedString(this.belongsToRequester)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

