/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Schema to identify an item by MarketPlaceId and ASIN.")
public class ASINIdentifier {
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;

    public ASINIdentifier marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="A marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ASINIdentifier ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(required=true, description="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASINIdentifier asINIdentifier = (ASINIdentifier)o;
        return Objects.equals(this.marketplaceId, asINIdentifier.marketplaceId) && Objects.equals(this.ASIN, asINIdentifier.ASIN);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.ASIN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ASINIdentifier {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

