/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.VerificationStatus;

@Schema(description="The types of verification details that may be provided for the order and the criteria required for when the type of verification detail can be provided. The types of verification details allowed depend on the type of regulated product and will not change order to order.")
public class ValidVerificationDetail {
    @SerializedName(value="VerificationDetailType")
    private String verificationDetailType = null;
    @SerializedName(value="ValidVerificationStatuses")
    private List<VerificationStatus> validVerificationStatuses = new ArrayList<VerificationStatus>();

    public ValidVerificationDetail verificationDetailType(String verificationDetailType) {
        this.verificationDetailType = verificationDetailType;
        return this;
    }

    @Schema(required=true, description="A supported type of verification detail. The type indicates which verification detail could be shared while updating the regulated order. Valid value: `prescriptionDetail`.")
    public String getVerificationDetailType() {
        return this.verificationDetailType;
    }

    public void setVerificationDetailType(String verificationDetailType) {
        this.verificationDetailType = verificationDetailType;
    }

    public ValidVerificationDetail validVerificationStatuses(List<VerificationStatus> validVerificationStatuses) {
        this.validVerificationStatuses = validVerificationStatuses;
        return this;
    }

    public ValidVerificationDetail addValidVerificationStatusesItem(VerificationStatus validVerificationStatusesItem) {
        this.validVerificationStatuses.add(validVerificationStatusesItem);
        return this;
    }

    @Schema(required=true, description="A list of valid verification statuses where the associated verification detail type may be provided. For example, if the value of this field is [\"Approved\"], calls to provide the associated verification detail will fail for orders with a `VerificationStatus` of `Pending`, `Rejected`, `Expired`, or `Cancelled`.")
    public List<VerificationStatus> getValidVerificationStatuses() {
        return this.validVerificationStatuses;
    }

    public void setValidVerificationStatuses(List<VerificationStatus> validVerificationStatuses) {
        this.validVerificationStatuses = validVerificationStatuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidVerificationDetail validVerificationDetail = (ValidVerificationDetail)o;
        return Objects.equals(this.verificationDetailType, validVerificationDetail.verificationDetailType) && Objects.equals(this.validVerificationStatuses, validVerificationDetail.validVerificationStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.verificationDetailType, this.validVerificationStatuses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidVerificationDetail {\n");
        sb.append("    verificationDetailType: ").append(this.toIndentedString(this.verificationDetailType)).append("\n");
        sb.append("    validVerificationStatuses: ").append(this.toIndentedString(this.validVerificationStatuses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

