/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Information about withheld taxes.")
public class TaxCollection {
    @SerializedName(value="Model")
    private ModelEnum model = null;
    @SerializedName(value="ResponsibleParty")
    private ResponsiblePartyEnum responsibleParty = null;

    public TaxCollection model(ModelEnum model) {
        this.model = model;
        return this;
    }

    @Schema(description="The tax collection model applied to the item.")
    public ModelEnum getModel() {
        return this.model;
    }

    public void setModel(ModelEnum model) {
        this.model = model;
    }

    public TaxCollection responsibleParty(ResponsiblePartyEnum responsibleParty) {
        this.responsibleParty = responsibleParty;
        return this;
    }

    @Schema(description="The party responsible for withholding the taxes and remitting them to the taxing authority.")
    public ResponsiblePartyEnum getResponsibleParty() {
        return this.responsibleParty;
    }

    public void setResponsibleParty(ResponsiblePartyEnum responsibleParty) {
        this.responsibleParty = responsibleParty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxCollection taxCollection = (TaxCollection)o;
        return Objects.equals((Object)this.model, (Object)taxCollection.model) && Objects.equals((Object)this.responsibleParty, (Object)taxCollection.responsibleParty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.responsibleParty});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxCollection {\n");
        sb.append("    model: ").append(this.toIndentedString((Object)this.model)).append("\n");
        sb.append("    responsibleParty: ").append(this.toIndentedString((Object)this.responsibleParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResponsiblePartyEnum {
        AMAZON_SERVICES_INC_("Amazon Services, Inc.");

        private String value;

        private ResponsiblePartyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResponsiblePartyEnum fromValue(String input) {
            for (ResponsiblePartyEnum b : ResponsiblePartyEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResponsiblePartyEnum> {
            public void write(JsonWriter jsonWriter, ResponsiblePartyEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ResponsiblePartyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResponsiblePartyEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ModelEnum {
        MARKETPLACEFACILITATOR("MarketplaceFacilitator");

        private String value;

        private ModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ModelEnum fromValue(String input) {
            for (ModelEnum b : ModelEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ModelEnum> {
            public void write(JsonWriter jsonWriter, ModelEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ModelEnum.fromValue(value);
            }
        }
    }
}

