/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.Measurement;

@Schema(description="Substitution options for an order item.")
public class SubstitutionOption {
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="QuantityOrdered")
    private Integer quantityOrdered = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="Title")
    private String title = null;
    @SerializedName(value="Measurement")
    private Measurement measurement = null;

    public SubstitutionOption ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(description="The item's Amazon Standard Identification Number (ASIN).")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public SubstitutionOption quantityOrdered(Integer quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
        return this;
    }

    @Schema(description="The number of items to be picked for this substitution option. ")
    public Integer getQuantityOrdered() {
        return this.quantityOrdered;
    }

    public void setQuantityOrdered(Integer quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
    }

    public SubstitutionOption sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @Schema(description="The item's seller stock keeping unit (SKU).")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public SubstitutionOption title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The item's title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SubstitutionOption measurement(Measurement measurement) {
        this.measurement = measurement;
        return this;
    }

    @Schema(description="")
    public Measurement getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstitutionOption substitutionOption = (SubstitutionOption)o;
        return Objects.equals(this.ASIN, substitutionOption.ASIN) && Objects.equals(this.quantityOrdered, substitutionOption.quantityOrdered) && Objects.equals(this.sellerSKU, substitutionOption.sellerSKU) && Objects.equals(this.title, substitutionOption.title) && Objects.equals(this.measurement, substitutionOption.measurement);
    }

    public int hashCode() {
        return Objects.hash(this.ASIN, this.quantityOrdered, this.sellerSKU, this.title, this.measurement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubstitutionOption {\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    quantityOrdered: ").append(this.toIndentedString(this.quantityOrdered)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    measurement: ").append(this.toIndentedString(this.measurement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

