/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Information about the prescription that is used to verify a regulated product. This must be provided once per order and reflect the seller\u2019s own records. Only approved orders can have prescriptions.")
public class PrescriptionDetail {
    @SerializedName(value="prescriptionId")
    private String prescriptionId = null;
    @SerializedName(value="expirationDate")
    private OffsetDateTime expirationDate = null;
    @SerializedName(value="writtenQuantity")
    private Integer writtenQuantity = null;
    @SerializedName(value="totalRefillsAuthorized")
    private Integer totalRefillsAuthorized = null;
    @SerializedName(value="refillsRemaining")
    private Integer refillsRemaining = null;
    @SerializedName(value="clinicId")
    private String clinicId = null;
    @SerializedName(value="usageInstructions")
    private String usageInstructions = null;

    public PrescriptionDetail prescriptionId(String prescriptionId) {
        this.prescriptionId = prescriptionId;
        return this;
    }

    @Schema(required=true, description="The identifier for the prescription used to verify the regulated product.")
    public String getPrescriptionId() {
        return this.prescriptionId;
    }

    public void setPrescriptionId(String prescriptionId) {
        this.prescriptionId = prescriptionId;
    }

    public PrescriptionDetail expirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Schema(required=true, description="The expiration date of the prescription used to verify the regulated product, in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format.")
    public OffsetDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public PrescriptionDetail writtenQuantity(Integer writtenQuantity) {
        this.writtenQuantity = writtenQuantity;
        return this;
    }

    @Schema(required=true, description="The number of units in each fill as provided in the prescription.")
    public Integer getWrittenQuantity() {
        return this.writtenQuantity;
    }

    public void setWrittenQuantity(Integer writtenQuantity) {
        this.writtenQuantity = writtenQuantity;
    }

    public PrescriptionDetail totalRefillsAuthorized(Integer totalRefillsAuthorized) {
        this.totalRefillsAuthorized = totalRefillsAuthorized;
        return this;
    }

    @Schema(required=true, description="The total number of refills written in the original prescription used to verify the regulated product. If a prescription originally had no refills, this value must be 0.")
    public Integer getTotalRefillsAuthorized() {
        return this.totalRefillsAuthorized;
    }

    public void setTotalRefillsAuthorized(Integer totalRefillsAuthorized) {
        this.totalRefillsAuthorized = totalRefillsAuthorized;
    }

    public PrescriptionDetail refillsRemaining(Integer refillsRemaining) {
        this.refillsRemaining = refillsRemaining;
        return this;
    }

    @Schema(required=true, description="The number of refills remaining for the prescription used to verify the regulated product. If a prescription originally had 10 total refills, this value must be `10` for the first order, `9` for the second order, and `0` for the eleventh order. If a prescription originally had no refills, this value must be 0.")
    public Integer getRefillsRemaining() {
        return this.refillsRemaining;
    }

    public void setRefillsRemaining(Integer refillsRemaining) {
        this.refillsRemaining = refillsRemaining;
    }

    public PrescriptionDetail clinicId(String clinicId) {
        this.clinicId = clinicId;
        return this;
    }

    @Schema(required=true, description="The identifier for the clinic which provided the prescription used to verify the regulated product.")
    public String getClinicId() {
        return this.clinicId;
    }

    public void setClinicId(String clinicId) {
        this.clinicId = clinicId;
    }

    public PrescriptionDetail usageInstructions(String usageInstructions) {
        this.usageInstructions = usageInstructions;
        return this;
    }

    @Schema(required=true, description="The instructions for the prescription as provided by the approver of the regulated product.")
    public String getUsageInstructions() {
        return this.usageInstructions;
    }

    public void setUsageInstructions(String usageInstructions) {
        this.usageInstructions = usageInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrescriptionDetail prescriptionDetail = (PrescriptionDetail)o;
        return Objects.equals(this.prescriptionId, prescriptionDetail.prescriptionId) && Objects.equals(this.expirationDate, prescriptionDetail.expirationDate) && Objects.equals(this.writtenQuantity, prescriptionDetail.writtenQuantity) && Objects.equals(this.totalRefillsAuthorized, prescriptionDetail.totalRefillsAuthorized) && Objects.equals(this.refillsRemaining, prescriptionDetail.refillsRemaining) && Objects.equals(this.clinicId, prescriptionDetail.clinicId) && Objects.equals(this.usageInstructions, prescriptionDetail.usageInstructions);
    }

    public int hashCode() {
        return Objects.hash(this.prescriptionId, this.expirationDate, this.writtenQuantity, this.totalRefillsAuthorized, this.refillsRemaining, this.clinicId, this.usageInstructions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrescriptionDetail {\n");
        sb.append("    prescriptionId: ").append(this.toIndentedString(this.prescriptionId)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    writtenQuantity: ").append(this.toIndentedString(this.writtenQuantity)).append("\n");
        sb.append("    totalRefillsAuthorized: ").append(this.toIndentedString(this.totalRefillsAuthorized)).append("\n");
        sb.append("    refillsRemaining: ").append(this.toIndentedString(this.refillsRemaining)).append("\n");
        sb.append("    clinicId: ").append(this.toIndentedString(this.clinicId)).append("\n");
        sb.append("    usageInstructions: ").append(this.toIndentedString(this.usageInstructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

