/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.BusinessHours;
import software.amazon.spapi.models.orders.v0.ExceptionDates;

@Schema(description="The time window when the delivery is preferred.")
public class PreferredDeliveryTime {
    @SerializedName(value="BusinessHours")
    private List<BusinessHours> businessHours = null;
    @SerializedName(value="ExceptionDates")
    private List<ExceptionDates> exceptionDates = null;

    public PreferredDeliveryTime businessHours(List<BusinessHours> businessHours) {
        this.businessHours = businessHours;
        return this;
    }

    public PreferredDeliveryTime addBusinessHoursItem(BusinessHours businessHoursItem) {
        if (this.businessHours == null) {
            this.businessHours = new ArrayList<BusinessHours>();
        }
        this.businessHours.add(businessHoursItem);
        return this;
    }

    @Schema(description="Business hours when the business is open for deliveries.")
    public List<BusinessHours> getBusinessHours() {
        return this.businessHours;
    }

    public void setBusinessHours(List<BusinessHours> businessHours) {
        this.businessHours = businessHours;
    }

    public PreferredDeliveryTime exceptionDates(List<ExceptionDates> exceptionDates) {
        this.exceptionDates = exceptionDates;
        return this;
    }

    public PreferredDeliveryTime addExceptionDatesItem(ExceptionDates exceptionDatesItem) {
        if (this.exceptionDates == null) {
            this.exceptionDates = new ArrayList<ExceptionDates>();
        }
        this.exceptionDates.add(exceptionDatesItem);
        return this;
    }

    @Schema(description="Dates when the business is closed during the next 30 days.")
    public List<ExceptionDates> getExceptionDates() {
        return this.exceptionDates;
    }

    public void setExceptionDates(List<ExceptionDates> exceptionDates) {
        this.exceptionDates = exceptionDates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferredDeliveryTime preferredDeliveryTime = (PreferredDeliveryTime)o;
        return Objects.equals(this.businessHours, preferredDeliveryTime.businessHours) && Objects.equals(this.exceptionDates, preferredDeliveryTime.exceptionDates);
    }

    public int hashCode() {
        return Objects.hash(this.businessHours, this.exceptionDates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreferredDeliveryTime {\n");
        sb.append("    businessHours: ").append(this.toIndentedString(this.businessHours)).append("\n");
        sb.append("    exceptionDates: ").append(this.toIndentedString(this.exceptionDates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

