/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.BuyerTaxInfo;

@Schema(description="Buyer information for an order.")
public class OrderBuyerInfo {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="BuyerEmail")
    private String buyerEmail = null;
    @SerializedName(value="BuyerName")
    private String buyerName = null;
    @SerializedName(value="BuyerCounty")
    private String buyerCounty = null;
    @SerializedName(value="BuyerTaxInfo")
    private BuyerTaxInfo buyerTaxInfo = null;
    @SerializedName(value="PurchaseOrderNumber")
    private String purchaseOrderNumber = null;

    public OrderBuyerInfo amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order identifier, in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public OrderBuyerInfo buyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
        return this;
    }

    @Schema(description="The anonymized email address of the buyer.")
    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public OrderBuyerInfo buyerName(String buyerName) {
        this.buyerName = buyerName;
        return this;
    }

    @Schema(description="The buyer name or the recipient name.")
    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public OrderBuyerInfo buyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
        return this;
    }

    @Schema(description="The county of the buyer.  **Note**: This attribute is only available in the Brazil marketplace.")
    public String getBuyerCounty() {
        return this.buyerCounty;
    }

    public void setBuyerCounty(String buyerCounty) {
        this.buyerCounty = buyerCounty;
    }

    public OrderBuyerInfo buyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
        return this;
    }

    @Schema(description="")
    public BuyerTaxInfo getBuyerTaxInfo() {
        return this.buyerTaxInfo;
    }

    public void setBuyerTaxInfo(BuyerTaxInfo buyerTaxInfo) {
        this.buyerTaxInfo = buyerTaxInfo;
    }

    public OrderBuyerInfo purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="The purchase order (PO) number entered by the buyer at checkout. Only returned for orders where the buyer entered a PO number at checkout.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBuyerInfo orderBuyerInfo = (OrderBuyerInfo)o;
        return Objects.equals(this.amazonOrderId, orderBuyerInfo.amazonOrderId) && Objects.equals(this.buyerEmail, orderBuyerInfo.buyerEmail) && Objects.equals(this.buyerName, orderBuyerInfo.buyerName) && Objects.equals(this.buyerCounty, orderBuyerInfo.buyerCounty) && Objects.equals(this.buyerTaxInfo, orderBuyerInfo.buyerTaxInfo) && Objects.equals(this.purchaseOrderNumber, orderBuyerInfo.purchaseOrderNumber);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.buyerEmail, this.buyerName, this.buyerCounty, this.buyerTaxInfo, this.purchaseOrderNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderBuyerInfo {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    buyerEmail: ").append(this.toIndentedString(this.buyerEmail)).append("\n");
        sb.append("    buyerName: ").append(this.toIndentedString(this.buyerName)).append("\n");
        sb.append("    buyerCounty: ").append(this.toIndentedString(this.buyerCounty)).append("\n");
        sb.append("    buyerTaxInfo: ").append(this.toIndentedString(this.buyerTaxInfo)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

