/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.Address;
import software.amazon.spapi.models.orders.v0.DeliveryPreferences;

@Schema(description="The shipping address for the order.")
public class OrderAddress {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="BuyerCompanyName")
    private String buyerCompanyName = null;
    @SerializedName(value="ShippingAddress")
    private Address shippingAddress = null;
    @SerializedName(value="DeliveryPreferences")
    private DeliveryPreferences deliveryPreferences = null;

    public OrderAddress amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order identifier, in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public OrderAddress buyerCompanyName(String buyerCompanyName) {
        this.buyerCompanyName = buyerCompanyName;
        return this;
    }

    @Schema(description="The company name of the contact buyer. For IBA orders, the buyer company must be Amazon entities.")
    public String getBuyerCompanyName() {
        return this.buyerCompanyName;
    }

    public void setBuyerCompanyName(String buyerCompanyName) {
        this.buyerCompanyName = buyerCompanyName;
    }

    public OrderAddress shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @Schema(description="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public OrderAddress deliveryPreferences(DeliveryPreferences deliveryPreferences) {
        this.deliveryPreferences = deliveryPreferences;
        return this;
    }

    @Schema(description="")
    public DeliveryPreferences getDeliveryPreferences() {
        return this.deliveryPreferences;
    }

    public void setDeliveryPreferences(DeliveryPreferences deliveryPreferences) {
        this.deliveryPreferences = deliveryPreferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAddress orderAddress = (OrderAddress)o;
        return Objects.equals(this.amazonOrderId, orderAddress.amazonOrderId) && Objects.equals(this.buyerCompanyName, orderAddress.buyerCompanyName) && Objects.equals(this.shippingAddress, orderAddress.shippingAddress) && Objects.equals(this.deliveryPreferences, orderAddress.deliveryPreferences);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.buyerCompanyName, this.shippingAddress, this.deliveryPreferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAddress {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    buyerCompanyName: ").append(this.toIndentedString(this.buyerCompanyName)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    deliveryPreferences: ").append(this.toIndentedString(this.deliveryPreferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

